//
//  YHUatHelper.swift
//  galaxy
//
//  Created by david on 2024/7/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHUatModules: Int {
    /*
     默认展示
     1、我的-我的名片、 true
     2、我的-积分中心、true
     3、我的-我的测评码、true
     4、我的-关于银河湾、true
     5、我的-我的活动、true
     6、我的-关于我们、true

     默认不展示
     7、服务-订单搜索、false
     
     8、更新-强制更新弹窗、true
     9、更新-建议更新弹窗、false
     
     10、七鱼智能客服、false
     */
    
    case Mine_Unknow = 0
    case Mine_MyCard = 1 // 我的-我的名片
    case Mine_IntegralCenter = 2 // 我的-积分中心
    case Mine_EvaluationCode = 3 // 我的-我的测评码
    case Mine_AboutYinHeHarbour = 4 // 我的-关于银河湾
    case Mine_MyActivity = 5 // 我的-我的活动
    case Mine_AboutUS = 6 // 我的-关于我们
    
    case Service_OrderSearch = 7 //服务-订单搜索
    
    case Update_Fource = 8 //更新-强制更新弹窗
    case Update_Suggest = 9 //更新-建议更新弹窗
    
    case QiYu_Service = 10 //七鱼智能客服入口
    
    
    //1-可见  2-不可见  3-新界面
    var defaultValue : Int {
        switch self {
        case .Mine_MyCard:
            return 1
        case .Mine_IntegralCenter:
            return 1
        case .Mine_EvaluationCode:
            return 1
        case .Mine_AboutYinHeHarbour:
            return 1
        case .Mine_MyActivity:
            return 1
        case .Mine_AboutUS:
            return 1
            
        case .Service_OrderSearch:
            return 2
        case .Update_Fource:
            return 2
        case .Update_Suggest:
            return 2
        case .QiYu_Service:
            return 2
        default:
            return 2
        }
    }
}


class YHUatHelper: NSObject {
    static let shared = YHUatHelper()
    
    private var isDataOk : Bool = false
    
    private lazy var viewModel: YHUatHelperViewModel = {
        let vm = YHUatHelperViewModel()
        return vm
    }()
    
    override init() {
        super.init()
        
        
        NotificationCenter.default.addObserver(self, selector: #selector(loginSuccess), name: YhConstant.YhNotification.didLoginSuccessNotifiction, object: nil)
        
        NotificationCenter.default.addObserver(self, selector: #selector(logoutSuccess), name: YhConstant.YhNotification.didLogoutSuccessNotifiction, object: nil)
        
        
    }
}

// MARK: - 私有方法
private extension YHUatHelper {
    
    @objc func loginSuccess() {
        isDataOk = false
        loadUatData()
    }
    
    @objc func logoutSuccess() {
        viewModel.dataList = nil
    }
}

// MARK: - 公有方法
extension YHUatHelper {
    
    //获取功能模块的展示状态
    func getUatModuleStatusBy(module : YHUatModules?) -> Int {
        guard let module = module else { return 1 }
        //1.查找服务端返回的值
        
        if let arr = viewModel.dataList?.list {
            for (_,item) in arr.enumerated() {
                if item.module_number.int == module.rawValue,item.result == 2 {
                    if let model = item.show_config {
                        return model.op
                    }
                    return module.defaultValue
                }
            }
        }
        
        //2.返回默认值
        return module.defaultValue
    }
    
    //加载服务器的uat配置
    func loadUatData() {
        
        if !YHNetworkStatusManager.shared.isNetWorkOK {
            printLog("网络不可用")
            return
        }
        
        if !YHLoginManager.shared.isLogin() {
            printLog("未登录 不请求")
            return
        }
        
        if !isDataOk {
            viewModel.getUatList { success, error in
                if success {
                    self.isDataOk = true
                    NotificationCenter.default.post(name: YhConstant.YhNotification.didRevUatParam, object: nil)
                } else {
                    self.isDataOk = false
                }
            }
        }
    }
}
