//
//  BsAllApiName.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2024/01/04.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//


class YHAllApiName {
    //办证段 - 6旅行证件准备
    struct TravelDocsPreparation {
        //GetTravelCertList 获取旅行证件列表
        static let getTravelDocsListApi = "super-app/order/customer/service/certificate/list"
        
        //GetTravelCertDetail 获取旅行证件详情
        static let getTravelDocsDetailApi = "super-app/order/customer/service/certificate/detail"
        
        //SaveTravelCert 保存旅行证件
        static let saveTravelDocsInfoApi = "super-app/order/customer/service/certificate/save"
    }
    
    //办证段 - 7上传过关证件
    struct UploadCertificate {
        //GetDocumentsList 获取上传列表内容
        static let getDocListApi = "super-app/order/customer/documents/list"
        
        //SubmitDocumentSmallWhiteBar 提交小白条
        static let submitSmallWhiteBarApi = "super-app/order/customer/documents/submit/small-white-bar"
        
        //SubmitDocumentIDCard 提交身份证
        static let submitIdCardApi = "super-app/order/customer/documents/submit/id-card"
        
        //过关证件详情
        static let getDocmentDetailApi = "super-app/order/customer/documents/detail"
    }
    
    //办证段 - 4签证缴费
    struct VisaPayment {
        //GetUserPaymentList 电子签证缴费列表
        static let paymentListApi = "super-app/order/customer/service/payment"
        
        
        //PushToResultQueryQueue 推送到结果查询队列
        static let paymentResultApi = "super-app/order/customer/service/payment/query"
        
        //获取影刀查询状态
        static let paymentUpdateApi = "super-app/order/customer/service/payment/query"
    }
    
    //灰度功能接口
    struct Uat {
        //获取 灰度功能列表
        static let uatListApi = "super-app/grayscale/match-result-batch"
    }
    
    
    //活动相关接口
    struct Activity {
        //活动列表
        static let listApi = "super-app/activity/list"
        
        //我的活动列表
        static let myListApi = "super-app/activity/mine"
        
        //活动详情
        static let detailApi = "super-app/activity/detail"
        
        //活动报名
        static let applyApi = "super-app/activity/join"
        
        //活动行程单
        static let travelApi = "super-app/activity/check-list"
        
        //取消活动报名
        static let cancelApi = "super-app/activity/cancel"
    }
    
    
    //首页界面相关接口
    struct Home {
        //获取签约用户的 最新信息提醒
        static let lastUnreadMessageApi = "super-app/infoflow/latest-unread-messages"
        
        //获取签约用户信息
        static let signerInfoApi = "super-app/infoflow/signer/info"
    }
    
    //接口 模块名 Common
    struct Common {
        //首页配置接口
        static let homeConfigApi = "super-app/config/app"
        //获取首页展示的资讯
        static let consultApi = "infoflow/home/consult"
        //获取首页展示的banner
        static let banner = "infoflow/banner/list"
        //获取栏目
        static let classify = "infoflow/classify/list"
        //获取资讯
        static let article = "infoflow/article/list"
        //资讯详情
        static let webInfo = "infoflow/article/info"
        //资讯收藏
        static let star = "infoflow/article/collect"
        //资讯点赞
        static let like = "infoflow/article/like"
        //我的点赞和收藏
        static let user = "infoflow/user/consult"
        //我的浏览
        static let userLook = "infoflow/user/view"
        //获取香港办事
        static let hklistApi = "infoflow/tool/list"
        // 点赞、收藏、最近浏览数量
        static let likeCollect = "infoflow/article/myArticleRecord"
        // 首页资讯栏目
        static let homeInfoClassifies = "infoflow/classify/classifies"
        // 首页身份、生活(类别)
        static let homeLifeCategory = "super-app/goods-category-info"
        // 首页身份、生活(详情)
        static let homeLifeDetail = "super-app/goods-info"
    }
    
    
   
    
    //order 模块
    struct Order {
        //合同列表
        static let contractListApi = "infoflow/order/list"
        
        static let main = "super-app/order/process_v2"
        //合同填写进度
        static let contractStatusApi = "infoflow/order/progress"
        
        //信息表的填写进度
        static let informationStepApi = "infoflow/order/information/step"
        
        //提交订单信息
        static let submitAllInfoApi = "infoflow/order/information/submit"
        
        
        //我的评分结果
        static let scoreDetailApi = "infoflow/orderAssessment/scoreDetail"
        
        
        //获取其他资料填写信息
        static let otherInfoFillApi = "infoflow/order/getOrderOtherInformation"
        //保存其他资料信息
        static let updateOtherInfoApi = "infoflow/order/updateOrderOtherInformation"
        
        //服务中心进度列表
        static let serviceCenterProgressApi = "infoflow/order/service-list"
        static let process = "super-app/order/process"
        //搜索白名单
        static let bywhitelist = "infoflow/permissiondict/bywhitelist"
        static let byorderid = "infoflow/order/byorderid"
        //协作订单
        static let assist = "infoflow/order/assist-list"
        //服务首页信息
        static let stage = "super-app/stage/information"
    }
    
    struct Family {
        // 获取家庭成员信息 添加家庭成员也用这个
        static let familyInfoApi = "infoflow/information/family"
        // 删除家庭成员信息
        static let deleteFamilyMemberApi = "infoflow/family/delete"
        // 提交家庭成员信息
        static let submitAllFamilyInfoApi = "infoflow/family/submit"
        // 某个家庭成员性情
        static let familyInfoDetailApi = "infoflow/information/member"
    }
    
    struct Education {
        // 获取教育和专业资格列表
        static let getEducationAndQulificationInfoListApi = "infoflow/getEducationList"
        // 获取学历详情信息
        static let getEducationDetailInfoApi = "infoflow/getEducationDetail"
        // 保存学历信息
        static let saveEducationInfoApi = "infoflow/saveEducationData"
        // 删除学历
        static let deleteEducationInfoApi = "infoflow/delEducationData"
        // 保存所有信息
        static let saveAllEduAndQuaInfoApi = "infoflow/submitEducert"
        // 搜索大学名称
        static let searchCollegeNameApi = "infoflow/getSchools"
        
    }
    
    struct Qualification {
        // 获取学历详情信息
        static let getQualificationDetailInfoApi = "infoflow/getQuaDetail"
        // 删除专业
        static let deleteQualificationInfoApi = "infoflow/delQualification"
        // 保存专业详情
        static let saveQualificationInfoApi =  "infoflow/saveQualification"
        
    }
    
    //Users
    struct Users {
        //提交 温馨提示信息
        static let submitSweetNotifyApi = "infoflow/users/sweet-notify/submit"
    }
    
    
    
    //Basics
    struct Basics {
        //获取 基本资料信息
        static let basicInfoApi = "infoflow/basics/get_basics"
        
        //保存基本资料信息
        static let  updateBasicInfoApi = "infoflow/basics/update_basics"
    }
    
    struct OrderInformation {
        //主申请人获取信息
        static let getInformation = "infoflow/order-information/get_information"
        // 主申请人信息更新
        static let updateInformation = "infoflow/order-information/update_information"
        // 主申请人国家信息
        static let countryInformation = "infoflow/country"
    }
    
    struct WorkExperience {
        //工作经验列表
        static let list = "infoflow/work/list"
        //工作经验详情
        static let detail = "infoflow/work/detail"
        //工作经验保存
        static let save = "infoflow/work/save"
        static let saveAll = "infoflow/work/save-all"
        //公司列表
        static let company = "infoflow/company/search"
        //工作经历删除
        static let del = "infoflow/work/del"
        //工作经历参考模版
        static let example = "infoflow/work/getWorkExampleList"
        static let projectExample = "infoflow/work/getWorkProjectExampleList"
        //工作经验项目保存
        static let saveProject = "infoflow/work/saveWorkProject"
        //工作经验项目列表
        static let projectList = "infoflow/work/getWorkProjectList"
        //工作经验项目列表
        static let projectDetail = "infoflow/work/getWorkProjectDetail"
        //删除工作经验项目
        static let projectDel = "infoflow/work/delWorkProject"
        //识别附件
        static let ocrFileContent = "infoflow/work/getOcrFileContent"
        //已上传文件列表
        static let fileList = "infoflow/work/file-list"
    }
    
    //登录
    struct Auth {
        static let login = "infoflow/auth/login"
        static let wxlogin = "infoflow/auth/wechat-login"
        static let oneKeyLogin = "infoflow/auth/native-login"
        static let appleLogin = "infoflow/auth/apple-login"
        static let oneKeySecretKeyInfo = "infoflow/auth/sdk-info"
        static let logout = "infoflow/auth/logout"
        static let getUidApi = "super-app/get-uid"
        //注销app
        static let unregisterApi = "infoflow/auth/cancellation"
    }
    
    //获取验证
    struct User {
        static let verifyCode = "cuser/user/verify-code"
    }
    
    //预览相关接口
    struct Preview {
        //其他信息
        static let previewOtherInfoApi = "infoflow/residence/preview"
        //基本资料
        static let previewBasicInfoApi = "infoflow/basics/get_basics"
        //主申请人信息
        static let previewMainApplicationInfoApi = "infoflow/order-information/preview_information"
        //家庭成员信息
        static let previewFamilyInfoApi = "infoflow/information/family"
        //学历/专业资格
        static let previewAcademicAndProfessionalQualificationInfoApi = "infoflow/education/preview"
        //工作经验
        static let previewWorkExpInfoApi = "infoflow/work/preview"
    }
    
    struct OSS {
        static let uploadApi = "oss/upload/storage"
        static let getPublicApi = "oss/storage/convertToPublicURL"
        static let getPublicUrlsApi = "oss/storage/batchConvertToPublicURL"
        static let getID = "ossv2/sts/auth"
    }
    
    struct OCR {
        //中国身份证识别
        static let cn = "ocr/id_card/recognize"
        //ocr港澳通行证识别 正面信息
        static let hk = "ocr/permit/recognize"
        
        // ocr港澳通行证 背面信息
        static let hkmacowBackInfoApi = "infoflow/order-information/get_hk_macao_pass"
        
        //普通文本识别 - eg：图片中扣字
        static let normal = "ocr/advanced/recognize"
        //小白条识别
        static let smallWhiteBarApi = "super-app/small-white-bar/read"
    }
    
    //我的签字
    struct Signature {
        // 签字列表
        static let list = "infoflow/my-sign/list"
        // 签字详情
        static let detail = "infoflow/my-sign/detail"
        // 获取签署url
        static let pageUrl = "infoflow/sign/page-url"
        // 获取实名认证Url
        static let personalUrl = "infoflow/sign/personal-auth"
        // 获取签署状态
        static let callBack = "infoflow/sign/check-is-complete"
        // 签字上传
        static let upload = "infoflow/sign/upload"
        // 签字下载
        static let download = "infoflow/sign/download"
        // 发送邮箱
        static let sendMail = "infoflow/sign/send_mail"
        static let sendDocMail = "infoflow/doc/send-mail"
        // 提交签字
        static let confirm = "infoflow/my-sign/confirm"
        // 查看合同
        static let look = "infoflow/sign/view-detail"
        // 查看签署状态
        static let signCallBack = "infoflow/sign/sign-callback"
        static let personal = "infoflow/sign/check-personal-status"
    }
    
    //我的文书
    struct Documents {
        // 文书列表
        static let listApi = "infoflow/my-doc/doc-list"
        // 文书详情
        static let detailApi = "infoflow/my-doc/doc-details"
        // 腾讯文档编辑
        static let temporaryUrlApi = "infoflow/my-doc/get_temporaryUrl"
        // 赴港计划书操作
        static let hkPlanApi = "infoflow/my-doc/hk-plan-edit"
        // 文书提交
        static let submitApi = "infoflow/my-doc/doc-submit"
        // 文书操作记录
        static let recordApi = "infoflow/my-doc/document-operation-record"
    }
    
    //我的证件
    struct Certificate {
        // 我的证件-状态数量统计
        static let statisticApi = "infoflow/certificate/statistic"
        
        // 清单列表
        static let documentListApi = "infoflow/certificate/certificate_document_list"
        
        // 证件列表
        static let certificateListApi = "infoflow/needUploadItems"
        
        // 证件上传
        static let certificateUploadApi = "infoflow/certificate/upload"
        
        //获取问答列表
        static let questionAndAnswerApi = "infoflow/answer-question/getAnswerQuestion"
    }
    
    // 我的方案
    struct Assessment {
        //方案计划
        static let applyPlanApi = "infoflow/assessment/apply_plan"
    }
    
    // 消息
    struct Message {
        // 获取未读消息列表
        static let unreadMsgListApi = "infoflow/unread-message"
        // 具体业务消息列表
        static let msgDetaiListApi = "infoflow/message/list/v2"
        // 标记消息已读
        static let readMsgApi = "infoflow/read-push"
        // 获取未读消息总数
        static let unreadTotalCountApi = "infoflow/unread-total"
        // 报备设备信息
        static let reportDeviceInfoApi = "infoflow/report-device-info"
    }
    
    // 人脉
    struct People {
        
        // 匹配用户
        static let matchUserListApi = "super-app/radar/list"
        // 添加好友
        static let addFriendApi = "super-app/community/friend-application"
        // 接收好友请求
        static let receiveFriendRequestApi = "super-app/community/process-friend-requests"
        // 好友列表
        static let friendListApi = "super-app/community/my-friends"
        // 用户名片
        static let nameCardInfoApi = "super-app/business-card/detail"
        // 我的名片
        static let myNameCardInfoApi = "super-app/business-card/my-detail"
        
        static let change = "super-app/avatar/change"
        static let userSubmit = "super-app/user-base/submit"
        static let authorizationSubmit = "super-app/authorization/submit"
        static let userInfoApi = "super-app/user-base/info"
        static let userAuthorization = "super-app/user/authorization"
        static let cardSave = "super-app/business-card/save"
        static let businessCardAuthorize = "super-app/business-card/authorize"
    }
    
    struct Share {
        static let cashOut = "super-app/cash-out/record"
        static let overview = "super-app/overview/record"
        static let record = "super-app/record/list"
    }
    
    struct Principle {
        //获取 获批信列表
        static let getApprovalLetterApi = "super-app/order/information/approval-letter"
        
        //上报原则批弹窗已展示
        static let postAlertStatusApi = "super-app/common/agreement/add"
        //原则批、正式批弹窗状态
        static let getAlertStatusApi = "super-app/home/agreement-check"
        //正式批操作指引是否确认
        static let getOfficialCheckStatusApi = "super-app/common/agreement/check"
        static let agreementCheck = "super-app/agreement/check"

        // 原则批审批结果
        static let getReviewResult = "super-app/order/approval/principle"
        // 获取档案号列表
        static let getProfileList = "super-app/order/approval/info"
        // 原则批详情
        static let getUploadDetail = "super-app/order/approval/uploadInfo"
        // 原则批已获批 是否发送邮件
        static let getIsSendMail = "super-app/order/customer/service/interview/is-send-email"
        // 原则批上传文件
        static let uploadFiles = "super-app/order/approval/upload/save"
        // 原则批发送邮件
        static let sendMail = "infoflow/file/send-mail"
    }
    
    struct MakeCertificate {
        
        //  获取香港服务列表
        static let servicelist = "super-app/order/customer/journey/journey-service"

    }
    
    struct FamilyInfoConfirm {
        // 获取获批者家庭信息
        static let familyInfo = "super-app/order/family/information/obtain"
        // 通过姓名获取拼音
        static let pinyinInfo = "super-app/order/information/pinyin"
        //  家庭信息-提交修改
        static let submitFamilyUpdate = "super-app/order/family/information/check"
        // 获批者家庭信息确认后下一步
        static let familyNext = "super-app/order/family/information/next"
        
    }
    
    //赴港办证预约
    struct AppointHK {
        // 保存香港额外服务
        static let saveExpectServiceApi = "super-app/expect-service/save"
        // 获取香港节假日
        static let hkholidaysApi = "super-app/holiday/get"
        //  所有赴港人员列表
        static let hkMembers = "super-app/order/hk/user"
        // 获取港府预约结果
        static let appointResult = "super-app/order/hk/reservation"
        // 是否需要赴港
        static let isNeedGoHK = "super-app/order/hk/get-need-to-hk"
        // 保存是否需要赴港
        static let saveNeedGoHK = "super-app/order/hk/save-need-to-hk"
        // 取消预约
        static let cancelAppoint = "super-app/reservation/cancel"
        // 港府办证地点列表
        static let cerPlaceList = "super-app/order/hk/select-position-list"
    }
    
    // 新增受养人
    struct Adopter {
        // 新增受养人首页
        static let main = "super-app/order/information/getDepList"
        // 点击新增受养人
        static let add = "super-app/order/information/dependent/add"
        // 新增配偶子女
        static let managementAdd = "super-app/order/information/management/add"
        
        static let del = "super-app/order/information/dependents/del"
        
        static let depositUpload = "super-app/order/information/deposit/upload"
        
        static let dependents = "super-app/order/information/dependents/get"
        
        static let dependentsAdd = "super-app/order/information/dependents/add"
        
        static let isReadAgreement = "super-app/order/is-read-agreement"
        
        static let dependentsUpload = "super-app/order/information/dependents/upload"
        
        static let dependentsCheck = "super-app/order/information/dependents/check"
    }
    
    // 七鱼透传信息获取
    struct QiYu {
        // 获取个人信息
        static let userInfomation = "super-app/qiyu/user/information"
    }
    
    // 续签资料
    struct ResignMaterial {
        static let resignMaterialList = "super-app/identity-renewal/renewal-batch-list"
    }
    
}
