//
//  YHRangeDatePickerCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSCalendar

class YHRangeDatePickerCell: FSCalendarCell {
    
    
    static let cellReuseIdentifier = "YHRangeDatePickerCell"
    
    public var middleLayer : CALayer = CALayer();
    public var selectionLayer : CALayer = CALayer();
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        let selectionLayer = CALayer()
        selectionLayer.cornerRadius = 3
        selectionLayer.backgroundColor = UIColor(red: 0, green: 0.275, blue: 0.706, alpha: 1).cgColor
        selectionLayer.actions = ["hidden": NSNull()]
        contentView.layer.insertSublayer(selectionLayer, below: titleLabel?.layer)
        self.selectionLayer = selectionLayer
        let middleLayer = CALayer()
        middleLayer.backgroundColor = UIColor(red: 0, green: 0.275, blue: 0.706, alpha: 0.08).cgColor
        middleLayer.actions = ["hidden": NSNull()]
        contentView.layer.insertSublayer(middleLayer, below: titleLabel?.layer)
        self.middleLayer = middleLayer
        shapeLayer.isHidden = true
    }
    
    required init!(coder aDecoder: NSCoder!) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        titleLabel?.frame = contentView.bounds
    }
    
    override func layoutSublayers(of layer: CALayer) {
        super.layoutSublayers(of: layer)
        
        middleLayer.frame = contentView.bounds
        selectionLayer.frame = contentView.bounds
    }
}
