//
//  YHPlanLinkShareView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/29.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHPlanShareItemButtonType: Int {
    case wechat = 1
    case copyLink = 2
    case saveImg = 3
    case cancel = 4
}

class YHPlanShareItemButton: UIButton {
    
    lazy var iconImgV: UIImageView = {
        let v = UIImageView()
        return v
    }()
    
    lazy var textLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = .init(hex: 0x666666)
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 13)
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(iconImgV)
        self.addSubview(textLabel)
        
        iconImgV.snp.makeConstraints { make in
            make.width.height.equalTo(48)
            make.top.equalTo(0)
            make.centerX.equalToSuperview()
        }
        
        textLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgV.snp.bottom).offset(8)
            make.centerX.equalToSuperview()
            make.height.equalTo(18)
        }
    }
}

class YHPlanLinkShareView: UIView {
    
    let wechatBtnTag = 9527
    let copyLinkTag = 9528
    let saveImgTag = 9529
    let cancelTag = 9530
    
    var clickBlock: ((YHPlanShareItemButtonType) -> Void)?

    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var cancelBtn: UIButton = {
        let btn = UIButton()
        btn.tag = cancelTag
        btn.backgroundColor = .init(hex: 0xF5F6F8)
        btn.setTitle("取消", for: .normal)
        btn.setTitleColor(.mainTextColor, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 16)
        btn.layer.cornerRadius = 3.0
        btn.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return btn
    }()
    
    lazy var wechatBtn: YHPlanShareItemButton = {
        let v = YHPlanShareItemButton()
        v.tag = wechatBtnTag
        v.textLabel.text = "微信"
        v.iconImgV.image = UIImage(named: "plan_share_wechat")
        v.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return v
    }()
    
    lazy var copyLinkBtn: YHPlanShareItemButton = {
        let v = YHPlanShareItemButton()
        v.tag = copyLinkTag
        v.textLabel.text = "复制链接"
        v.iconImgV.image = UIImage(named: "plan_share_copy")
        v.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return v
    }()
    
    lazy var saveImgBtn: YHPlanShareItemButton = {
        let v = YHPlanShareItemButton()
        v.tag = saveImgTag
        v.textLabel.text = "保存图片"
        v.iconImgV.image = UIImage(named: "plan_share_save")
        v.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return v
    }()
    
    static func alertView() -> YHPlanLinkShareView {
        let v = YHPlanLinkShareView(frame: UIScreen.main.bounds)
        return v
    }
    
    @objc func didFunctionBtnClicked(_ sender: UIButton) {
        if sender.tag == wechatBtnTag {
            clickBlock?(.wechat)
            
        } else if sender.tag == copyLinkTag {
            clickBlock?(.copyLink)

        } else if sender.tag == saveImgTag {
            clickBlock?(.saveImg)

        } else if sender.tag == cancelTag {
            
        }
        dismiss()
    }

    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        DispatchQueue.main.async {
            self.removeFromSuperview()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.backgroundColor = .init(hex: 0x000000, alpha: 0.7)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(wechatBtn)
        whiteContentView.addSubview(copyLinkBtn)
        whiteContentView.addSubview(saveImgBtn)
        whiteContentView.addSubview(cancelBtn)

        whiteContentView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(216)
        }
        
        copyLinkBtn.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(74)
            make.top.equalTo(20)
            make.centerX.equalToSuperview()
        }
        
        wechatBtn.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(74)
            make.top.equalTo(20)
            make.right.equalTo(copyLinkBtn.snp.left).offset(-70)
        }
        
        saveImgBtn.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(74)
            make.top.equalTo(20)
            make.left.equalTo(copyLinkBtn.snp.right).offset(70)
        }

        cancelBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(46)
            make.top.equalTo(copyLinkBtn.snp.bottom).offset(24)
        }
    }

}
