//
//  YHResignDocumentHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignDocumentHeaderCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHResignDocumentHeaderCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 17)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor50
        label.font = .PFSC_R(ofSize: 13)
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, detail: String?, cellType: YHResignRoundCellType = .top) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
        updateCellCorner(cellType)
    }
    
}

extension YHResignDocumentHeaderCell {
    
    private func setupUI() {
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(bottomLineView)
        infoTitleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.centerY.equalToSuperview()
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.right).offset(6)
            make.centerY.equalToSuperview()
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
    }
}
