//
//  YHPreviewInfoHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoHeaderCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHPreviewInfoHeaderCell"
    
    private lazy var infoNameLabel: UILabel = {
        let label = UILabel(text: "--")
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        return label
    }()
    
    private lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setup(title: String) {
        infoNameLabel.text = title
    }
    
    private func setupUI() {
        updateCellCorner(.top)
        subContainerView.addSubview(infoNameLabel)
        subContainerView.addSubview(lineView)
        infoNameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-12)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
    }
}
