//
//  YHMyWorkExperienceCell.swift
//  galaxy
//
//  Created by edy on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHExperienceItemView: UIView {
    
    static let detailFont = UIFont.PFSC_R(ofSize: 13)
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 13)
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor70
        label.textAlignment = .left
        label.font = Self.detailFont
        label.text = "填写最近一份工作经验"
        label.numberOfLines = 0
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(self.titleLabel)
        self.addSubview(self.detailLabel)
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.width.equalTo(52)
            make.height.equalTo(20)
            make.top.equalToSuperview()
        }
        self.detailLabel.snp.makeConstraints { make in
            make.left.equalTo(self.titleLabel.snp.right).offset(12)
            make.right.equalToSuperview()
            make.top.bottom.equalToSuperview()
        }
    }
}

class YHMyWorkExperienceCell: UITableViewCell {
    typealias EditBlock = () -> Void
    var editBlock: EditBlock?
    var hiddenBtnBlock: (() -> Void)?
    static let cellReuseIdentifier = "YHMyWorkExperienceCell"
    
    var userModel: YHUserNameCardInfo = YHUserNameCardInfo() {
        didSet {
            
            self.editBtn.isHidden = !self.userModel.isCurrentUser
            
            self.companyView.detailLabel.textColor = UIColor.mainTextColor70
            self.professionView.detailLabel.textColor = UIColor.mainTextColor70
            self.industryView.detailLabel.textColor = UIColor.mainTextColor70
            
            /* 公司文字处理 */
            var text1 = ""
            if !self.userModel.companyName.isEmpty {
                text1 = self.userModel.companyName
                self.companyView.isHidden = false
            } else {
                text1 = ""
                if self.userModel.isCurrentUser { // 当前用户要展示默认文案
                    self.companyView.detailLabel.textColor = UIColor.mainTextColor30
                    text1 = "请填写最近一份工作经历"
                }
            }
            self.companyView.detailLabel.text = text1
            self.companyView.isHidden = text1.isEmpty
            var itemView1Height = 0.0
            var top1Margin = 0.0
            if !text1.isEmpty {
                itemView1Height = self.getHeight(text: text1, font: YHExperienceItemView.detailFont, width: KScreenWidth-20.0*2-52-12)
                top1Margin = 16
            }
            companyView.snp.updateConstraints { make in
                make.height.equalTo(itemView1Height)
                make.top.equalTo(self.titleLabel.snp.bottom).offset(top1Margin)
            }
            
            /* 职位文字处理 */
            var text2 = ""
            if !self.userModel.position.isEmpty {
                text2 = self.userModel.position
                self.professionView.isHidden = false
                
            } else {
                if self.userModel.isCurrentUser { // 当前用户要展示默认文案
                    self.professionView.detailLabel.textColor = UIColor.mainTextColor30
                    text2 = "请填写最近一份工作经历"
                }
            }
            self.professionView.detailLabel.text = text2
            self.professionView.isHidden = text2.isEmpty
            var itemView2Height = 0.0
            var top2Margin = 0.0
            if !text2.isEmpty {
                itemView2Height = self.getHeight(text: text2, font: YHExperienceItemView.detailFont, width: KScreenWidth-20.0*2-52-12)
                top2Margin = 16
            }
            professionView.snp.updateConstraints { make in
                make.height.equalTo(itemView2Height)
                make.top.equalTo(self.companyView.snp.bottom).offset(top2Margin)
            }
            
            /* 行业文字处理 */
            var text3 = ""
            if !self.userModel.industry.isEmpty {
                text3 = self.userModel.industry
                self.industryView.isHidden = false
            } else {
                if self.userModel.isCurrentUser { // 当前用户要展示默认文案
                    self.industryView.detailLabel.textColor = UIColor.mainTextColor30
                    text3 = "请填写最近一份工作经历"
                }
            }
            self.industryView.detailLabel.text = text3
            self.industryView.isHidden = text3.isEmpty
            var itemView3Height = 0.0
            var top3Margin = 0.0
            if !text3.isEmpty {
                itemView3Height = self.getHeight(text: text3, font: YHExperienceItemView.detailFont, width: KScreenWidth-20.0*2-52-12)
                top3Margin = 16
            }
            industryView.snp.updateConstraints { make in
                make.height.equalTo(itemView3Height)
                make.top.equalTo(self.professionView.snp.bottom).offset(top3Margin)
            }
            
            if self.userModel.isCurrentUser {
                self.hiddenBtn.isHidden = !self.userModel.isHiddenWorkExperience
                
            } else {
                self.hiddenBtn.isHidden = true
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "工作经历"
        label.textColor = UIColor(hexString: "#222222")
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 17)
        return label
    }()
    
    lazy var editBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "people_card_edit"), for: .normal)
        btn.addTarget(self, action: #selector(edit), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        return btn
    }()
    
    lazy var hiddenBtn: UIButton = {
        let btn = UIButton()
        btn.isHidden = true
        btn.backgroundColor = UIColor.init(hex: 0xF4F6FA)
        btn.layer.cornerRadius = 3.0
        btn.setImage(UIImage(named: "people_card_hidden"), for: .normal)
        btn.setTitle("已隐藏", for: .normal)
        btn.setTitleColor(UIColor.mainTextColor50, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 10)
        btn.titleEdgeInsets = UIEdgeInsets(top: 0, left: -11, bottom: 0, right: 11)
        btn.imageEdgeInsets = UIEdgeInsets(top: 0, left: 31, bottom: 0, right: -31)
        btn.addTarget(self, action: #selector(didHiddenBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var companyView: YHExperienceItemView = {
        let view = YHExperienceItemView()
        view.titleLabel.text = "所在企业"
        return view
    }()
    
    lazy var professionView: YHExperienceItemView = {
        let view = YHExperienceItemView()
        view.titleLabel.text = "职位"
        return view
    }()
    
    lazy var industryView: YHExperienceItemView = {
        let view = YHExperienceItemView()
        view.titleLabel.text = "所在行业"
        return view
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .brandGrayColor3
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        
        self.contentView.addSubview(self.cardView)
        cardView.addSubview(self.titleLabel)
        cardView.addSubview(self.hiddenBtn)
        cardView.addSubview(self.editBtn)
        cardView.addSubview(self.companyView)
        cardView.addSubview(self.professionView)
        cardView.addSubview(self.industryView)
        cardView.addSubview(lineView)

        cardView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(24)
            make.height.equalTo(24)
        }
        
        editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.right.equalTo(-20)
            make.centerY.equalTo(titleLabel)
        }
        
        hiddenBtn.snp.makeConstraints { make in
            make.width.equalTo(50)
            make.height.equalTo(18)
            make.centerY.equalTo(self.titleLabel)
            make.left.equalTo(self.titleLabel.snp.right).offset(8)
            make.right.lessThanOrEqualTo(self.editBtn.snp.left).offset(-20)
        }
        
        companyView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(20)
            make.top.equalTo(self.titleLabel.snp.bottom).offset(16)
        }
        
        professionView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(20)
            make.top.equalTo(self.companyView.snp.bottom).offset(16)
        }
        
        industryView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(20)
            make.top.equalTo(self.professionView.snp.bottom).offset(16)
            make.bottom.equalToSuperview().offset(-24)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.bottom.equalTo(0)
            make.height.equalTo(1)
        }
    }
    
    func getHeight(text: String, font: UIFont, width: CGFloat) -> CGFloat {
        let size = CGSize.init(width: width, height: CGFloat(MAXFLOAT))
        let dic = [NSAttributedString.Key.font: font]
        let strSize = text.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: strSize.width, height: ceil(strSize.height)).height
    }

    @objc func edit() {
        if let block = editBlock {
            block()
        }
    }
    
    @objc func didHiddenBtnClicked() {
        self.hiddenBtnBlock?()
    }
}
