//
//  YHOtherInfoFillModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHOtherInfoFillModel: SmartCodable {
    var order_id: String = ""
    var residences: [Residence] = []
    var language_detail: LanguageDetail?
    
    // 服务器返回
    var language_detail_new: [LanguageDetailNew] = []
    
    // 数据储存在各端的数据
    var language_detail_new_data: [LanguageDetailModel] = []
    
    var profession: Profession?
    var question: Question?
    var is_update: Bool = false // true-提交  false-保存
    
    // 以下为本地使用的参数
    var needCheckFlag: Bool = false // 是否检查有效性
    
    required init() {
        
    }
}

// MARK: - Residence
class Residence: SmartCodable {
    var id: String = ""
    var country: String = ""
    var start_time: String = ""
    var end_time: String = ""
    
    var order_id: Int = -1
    var end_time_checked: Bool = false // 是否勾选 长期
    
    // 以下为本地使用的参数
    var needCheckFlag: Bool = false // 是否检查有效性
    
    required init() {
    }
}

// MARK: - LanguageDetail
class LanguageDetail: SmartCodable {
    var school_address_aboard: Bool = false // 修读学校是否在国外
    var level: Int = -1
    var levelDes: String = ""
    var name: String = ""
    var remark: String = ""
    var localRemark: String = ""
    
    // 以下为本地使用的参数
    var needCheckFlag: Bool = false // 是否检查有效性
    
    required init() {
        
    }
}

class LanguageDetailNew: SmartCodable {
    var id: Int = 0
    var first_select: Int = 0
    var second_select: String = "" // "1,2,3"  兼容多选
    var other_instructions: String = ""
    
    required init() {
    }
}

class LanguageOptionModel: SmartCodable {
    var id: Int = 0
    var name: String = ""
    var select: Bool = false
    var subname: String = ""
    var highlight: String = ""
    
    required init() {
    }
}

class LanguageDetailModel: SmartCodable {
    var id: Int = 0
    var name: String = ""
    var select: Bool = false
    var other_instructions: String = ""
    var options: [LanguageOptionModel] = []
    
    required init() {
    }
}

// MARK: - Profession
class Profession: SmartCodable {
    var option: Int = -1
    var optionDes: String = ""
    var remark: String = ""
    
    // 以下为本地使用的参数
    var needCheckFlag: Bool = false // 是否检查有效性
    
    required init() {
    }
}

// MARK: - Question
class Question: SmartCodable {
    var professional_qualification: Int = -1
    var paper: Int = -1
    var scholarship: Int = -1
    var media_interview: Int = -1
    var academic_awards: String = ""
    var professional_awards: String = ""
    var other_information: String = ""
    
    // 以下为本地使用的参数
    var needCheckFlag: Bool = false // 是否检查有效性
    
    required init() {
    }
}
