//
//  YHPreviewInfoNameAndDetailCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoNameAndDetailCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHPreviewInfoNameAndDetailCell"
    
    private lazy var infoNameLabel: UILabel = {
        let label = UILabel(text: "--")
        label.textColor = UIColor(hexString: "#8993A2")
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var infoSubtitleLabel: UILabel = {
        let label = UILabel(text: "--")
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textAlignment = .right
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setup(title: String, detail: String, cellType: YHResignRoundCellType, topMargin: CGFloat = 8, bottomMargin: CGFloat = 8) {
        infoNameLabel.text = title
        infoSubtitleLabel.text = detail
        infoSubtitleLabel.snp.remakeConstraints { make in
            make.left.greaterThanOrEqualTo(infoNameLabel.snp.right).offset(10)
            make.top.equalToSuperview().offset(topMargin)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-bottomMargin)
        }
        updateCellCorner(cellType)
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoNameLabel)
        subContainerView.addSubview(infoSubtitleLabel)
        infoNameLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoSubtitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        infoNameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.centerY.equalTo(infoSubtitleLabel)
        }
        
        infoSubtitleLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoNameLabel.snp.right).offset(10)
            make.top.equalToSuperview().offset(8)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-8)
        }
    }
}
