//
//  YHSignPrizeCellTableViewCell.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSignPrizeCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHSignPrizeCell"
    static let img_ratio = 1.0
    
    var onImageHeightChanged: (() -> Void)?
    
    private let containerView = UIView()
    private let greetingLabel = UILabel()
    private let instructionLabel = UILabel()
    private let prizeImageView = UIImageView()
    private let overlayButton = UIButton()
    private let backImgV: UIImageView = UIImageView()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = .clear
        selectionStyle = .none
        
        containerView.backgroundColor = .white
        containerView.layer.cornerRadius = 6
        contentView.addSubview(containerView)
        
        backImgV.image = UIImage(named: "salon_sign_bg")
        containerView.addSubview(backImgV)
        
        greetingLabel.font = .PFSC_B(ofSize: 18)
        greetingLabel.textColor = .brandGrayColor8
        containerView.addSubview(greetingLabel)
        
        instructionLabel.font = .PFSC_R(ofSize: 14)
        instructionLabel.textColor = .brandGrayColor7
        instructionLabel.text = "请联系现场工作人员领取您的奖品"
        containerView.addSubview(instructionLabel)
        
        prizeImageView.contentMode = .scaleAspectFill
        prizeImageView.clipsToBounds = true
        prizeImageView.layer.cornerRadius = 6
        containerView.addSubview(prizeImageView)
        
        containerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(0)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(0)
        }
        
        backImgV.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(118)
        }
        
        greetingLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(28)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        
        instructionLabel.snp.makeConstraints { make in
            make.top.equalTo(greetingLabel.snp.bottom).offset(8)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        
        prizeImageView.snp.makeConstraints { make in
            make.top.equalTo(instructionLabel.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-20)
            make.height.equalTo(295)
        }
    }
    
    func configure(with model: YHSignSuccessActivity) {
        greetingLabel.text = "你好，" + (model.user?.name ?? "")
        if let gift = model.gift {
            if let url = URL(string: gift.url) {
                prizeImageView.sd_setImage(with: url, placeholderImage: UIImage(named: "global_default_image")) { [weak self] image, _, _, _ in
                    guard let self = self else {
                        return
                    }
                    guard let image = image, image.size.width > 0, image.size.height > 0 else {
                        return
                    }
                    let ratio = image.size.height / image.size.width
                    self.prizeImageView.snp.updateConstraints { make in
                        make.height.equalTo(ratio * (KScreenWidth-40.0*2))
                    }
                    self.onImageHeightChanged?()
                
                }
            } else {
                self.prizeImageView.snp.updateConstraints { make in
                    make.height.equalTo(YHSignPrizeCell.img_ratio * (KScreenWidth-40.0*2))
                }
            }
        }
    }
}
