//
//  YHResourceDetailBaseInfoCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResourceDetailBaseInfoCell: UITableViewCell {
    
    private lazy var dividerView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.brandGrayColor3
        return view
    }()
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = UIColor.brandGrayColor8
        label.text = "基础信息"
        return label
    }()
    
    private lazy var stackView: UIStackView = {
        let stack = UIStackView()
        stack.axis = .vertical
        stack.spacing = 16
        stack.distribution = .fill
        return stack
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .white
        contentView.backgroundColor = .white
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(dividerView)
        contentView.addSubview(stackView)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.top.equalToSuperview().offset(24)
        }
        
        stackView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
        }
        let pixelOne = 1.0 / UIScreen.main.scale
        dividerView.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(20)
            make.top.equalTo(stackView.snp.bottom).offset(24)
            make.height.equalTo(pixelOne)
            make.bottom.equalToSuperview()
        }
    }
    
    func configure(with model: YHResourceDetailModel) {
        stackView.arrangedSubviews.forEach { $0.removeFromSuperview() }
        
        // 使用详情接口的字段
        addInfoRow(title: "企业介绍", content: model.company_introduction.isEmpty ? "-" : model.company_introduction)
        addInfoRow(title: "主营业务", content: model.company_business.isEmpty ? "-" : model.company_business)
        addInfoRow(title: "提供服务", content: model.resource_provided.isEmpty ? "-" : model.resource_provided)
        addInfoRow(title: "行业类型", content: model.industry_type_str.isEmpty ? "-" : model.industry_type_str)
    }
    
    private func addInfoRow(title: String, content: String) {
        let rowView = createInfoRowView(title: title, content: content)
        stackView.addArrangedSubview(rowView)
    }
    
    private func createInfoRowView(title: String, content: String) -> UIView {
        let container = UIView()
        
        let titleLabel = UILabel()
        titleLabel.font = UIFont.PFSC_R(ofSize: 13)
        titleLabel.textColor = UIColor.brandGrayColor6
        titleLabel.text = title
        titleLabel.setContentHuggingPriority(.required, for: .horizontal)
        titleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        let contentLabel = UILabel()
        contentLabel.font = UIFont.PFSC_R(ofSize: 13)
        contentLabel.textColor = UIColor.brandGrayColor8
        contentLabel.text = content
        contentLabel.numberOfLines = 4
        contentLabel.textAlignment = .left
        
        container.addSubview(titleLabel)
        container.addSubview(contentLabel)
        
        contentLabel.setContentHuggingPriority(.defaultLow, for: .horizontal)
        contentLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalToSuperview()
            make.width.equalTo(70)
        }
        
        contentLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(12)
            make.right.equalToSuperview()
            make.top.equalToSuperview()
            make.bottom.equalToSuperview()
        }
        
        return container
    }
}
