//
//  YHMyFriendsCell.swift
//  galaxy
//
//  Created by edy on 2024/6/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Kingfisher

class YHMyFriendsCell: UITableViewCell {

    static let cellReuseIdentifier = "YHMyFriendsCell"
    var friendModel: YHFriendModel = YHFriendModel() {
        didSet {
            if let url = URL(string: self.friendModel.avatar) {
                self.headImgV.kf.setImage(with: url, placeholder: UIImage(named: "people_head_default"))
            } else {
                self.headImgV.image = UIImage(named: "people_head_default")
            }
            self.nameLabel.text = self.friendModel.username
            self.detailLabel.text = self.friendModel.signature
//            self.signImgV.isHidden = !self.friendModel.isSign
            
            var text1 = ""
            var text1Arr: [String] = []
            if !self.friendModel.position.isEmpty {
                text1Arr.append(self.friendModel.position)
            }
            if !self.friendModel.industry.isEmpty {
                text1Arr.append(self.friendModel.industry)
            }
            if text1Arr.count > 0 {
                text1 = text1Arr.joined(separator: " | ")
            }
            self.professionalLabel.text = text1
            let topMargin = self.friendModel.signature.isEmpty ? 0.0 : 6.0
            let detailHeight = self.friendModel.signature.isEmpty ? 0.0 : 18.0
            self.detailLabel.snp.updateConstraints { make in
                make.height.equalTo(detailHeight)
                make.top.equalTo(self.professionalLabel.snp.bottom).offset(topMargin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var headImgV: UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_head_default"))
        view.layer.cornerRadius = 23.0
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_B(ofSize: 16)
        return nameLabel
    }()
    
    lazy var signImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_sign")
        view.isHidden = true
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandGrayColor3
        return view
    }()
    
    lazy var professionalLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor70
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 13)
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.backgroundColor = .white
        self.selectionStyle = .none
        
        self.contentView.addSubview(self.headImgV)
        self.contentView.addSubview(self.nameLabel)
        self.contentView.addSubview(self.signImgV)
        self.contentView.addSubview(self.professionalLabel)
        self.contentView.addSubview(self.detailLabel)
        self.contentView.addSubview(self.lineView)
        
        self.lineView.snp.makeConstraints { make in
            make.left.equalTo(15)
            make.right.equalTo(-15)
            make.top.equalTo(0)
            make.height.equalTo(0.5)
        }
        
        self.headImgV.snp.makeConstraints { make in
            make.width.height.equalTo(46.0)
            make.left.equalTo(16)
            make.top.equalTo(16)
        }
        
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalTo(self.headImgV.snp.right).offset(10)
            make.height.equalTo(22.0)
            make.top.equalTo(self.headImgV)
        }
        
        self.signImgV.snp.makeConstraints { make in
            make.width.equalTo(49)
            make.height.equalTo(16)
            make.centerY.equalTo(self.nameLabel)
            make.left.equalTo(self.nameLabel.snp.right).offset(8)
            make.right.lessThanOrEqualToSuperview().offset(-15)
        }
        
        self.professionalLabel.snp.makeConstraints { make in
            make.left.equalTo(self.nameLabel)
            make.right.equalTo(self.lineView)
            make.top.equalTo(self.nameLabel.snp.bottom).offset(6)
            make.height.equalTo(18)
        }
        
        self.detailLabel.snp.makeConstraints { make in
            make.left.equalTo(self.nameLabel)
            make.right.equalTo(self.lineView)
            make.height.equalTo(18.0)
            make.top.equalTo(self.professionalLabel.snp.bottom).offset(6)
            make.bottom.equalToSuperview().offset(-16)
        }
    }
}
