//
//  YHSelectLookHeadView.swift
//  galaxy
//
//  Created by EDY on 2024/11/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectLookHeadView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var buttonBlock: Block?
    var normalButton: UIButton!
    var hotButton: UIButton!
    var priceButton: UIButton!
    var buttonIndex = 0 {
        didSet {
            if buttonIndex == 0 {
                normalButton.isSelected = true
                hotButton.isSelected = false
                priceButton.isSelected = false
                
            } else if buttonIndex == 1 {
                normalButton.isSelected = false
                hotButton.isSelected = true
                priceButton.isSelected = false
            } else if buttonIndex == 2 {
                normalButton.isSelected = false
                hotButton.isSelected = false
                priceButton.isSelected = true
                priceButton.setImage(UIImage(named: "home_select_icon_select"), for: .selected)
            } else if buttonIndex == 3 {
                normalButton.isSelected = false
                hotButton.isSelected = false
                priceButton.isSelected = true
                priceButton.setImage(UIImage(named: "home_select_icon_select_two"), for: .selected)
            }
        }
    }
    var items: [String] = [] {
        didSet {
            self.myCollectView.reloadData()
        }
    }
    
    lazy var myCollectView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
//        flowLayout.itemSize = CGSize(width: 60, height: 76)
        flowLayout.minimumInteritemSpacing = 12.0
        flowLayout.minimumLineSpacing = 12.0
        flowLayout.scrollDirection = .horizontal
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .white
        collectinoView.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 20)
        collectinoView.register(YHSelectLookHeadViewCollectionViewCell.self, forCellWithReuseIdentifier: YHSelectLookHeadViewCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.bounces = false
        collectinoView.showsHorizontalScrollIndicator = false
        collectinoView.showsVerticalScrollIndicator = false
        return collectinoView
    }()
    
    var selectIndex = 0 {
        didSet {
        }
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .white
        addSubview(myCollectView)
        myCollectView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(46)
        }
        normalButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.contentHorizontalAlignment = .center
            button.setTitle("默认", for: .normal)
//            button.setImage(UIImage(named: "home_select_icon"), for: .normal)
            button.setTitleColor(UIColor(hex: 0x8993a2), for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
//            button.setImage(UIImage(named: "home_select_icon_select"), for: .selected)
            button.addTarget(self, action: #selector(normalClick), for: .touchUpInside)
            button.isSelected = true
            button.isHidden = true
            return button
        }()
        addSubview(normalButton)
        normalButton.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.bottom.equalTo(-7)
            make.height.equalTo(16)
            make.width.equalTo(24)
        }
        hotButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.contentHorizontalAlignment = .center
            button.setTitle("热门", for: .normal)
//            button.setImage(UIImage(named: "home_select_icon"), for: .normal)
            button.setTitleColor(UIColor(hex: 0x8993a2), for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
//            button.setImage(UIImage(named: "home_select_icon_select"), for: .selected)
            button.addTarget(self, action: #selector(hotClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        addSubview(hotButton)
        hotButton.snp.makeConstraints { make in
            make.left.equalTo(normalButton.snp.right).offset(20)
            make.bottom.equalTo(-7)
            make.height.equalTo(16)
            make.width.equalTo(24)
        }
        priceButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.contentHorizontalAlignment = .center
            button.setTitle("价格", for: .normal)
            button.setImage(UIImage(named: "home_select_icon"), for: .normal)
            button.setTitleColor(UIColor(hex: 0x8993a2), for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setImage(UIImage(named: "home_select_icon_select"), for: .selected)
            button.addTarget(self, action: #selector(priceClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        addSubview(priceButton)
        priceButton.snp.makeConstraints { make in
            make.left.equalTo(hotButton.snp.right).offset(20)
            make.bottom.equalTo(-7)
            make.height.equalTo(16)
            make.width.equalTo(40)
        }
        priceButton.iconInRight(with: 0.5)
    }
    
    @objc func normalClick() {
        normalButton.isSelected = true
        hotButton.isSelected = false
        priceButton.isSelected = false
        if let block = self.buttonBlock {
            block(0)
        }
        buttonIndex = 0
    }
    @objc func hotClick() {
        normalButton.isSelected = false
        hotButton.isSelected = true
        priceButton.isSelected = false
        if let block = self.buttonBlock {
            block(1)
        }
        buttonIndex = 1
    }
    @objc func priceClick() {
        normalButton.isSelected = false
        hotButton.isSelected = false
        priceButton.isSelected = true
        if buttonIndex != 2 {
            if let block = self.buttonBlock {
                block(2)
            }
            buttonIndex = 2
            priceButton.setImage(UIImage(named: "home_select_icon_select"), for: .selected)
        } else {
            if let block = self.buttonBlock {
                block(3)
            }
            buttonIndex = 3
            priceButton.setImage(UIImage(named: "home_select_icon_select_two"), for: .selected)
        }
        
    }
}

extension YHSelectLookHeadView: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return items.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHSelectLookHeadViewCollectionViewCell.cellReuseIdentifier, for: indexPath) as? YHSelectLookHeadViewCollectionViewCell else { return UICollectionViewCell() }
        cell.dataSource = items[indexPath.row]
        
        if indexPath.row == selectIndex {
            cell.setSelectedStyle()
        } else {
            cell.setDeSelectedStyle()
        }
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectIndex = indexPath.row
        buttonIndex = 0
        collectionView.reloadData()
        if let block = block {
            block(indexPath.row)
            normalButton.isHidden = false
            hotButton.isHidden = false
            priceButton.isHidden = false
            if indexPath.row == 0 {
                normalButton.isHidden = true
                hotButton.isHidden = true
                priceButton.isHidden = true
            }
        }
        collectionView.scrollToItem(at: indexPath, at: .centeredHorizontally, animated: true)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        // 根据数据内容计算单元格的大小
        let text = items[indexPath.row] // 要显示的文本内容
        let font = UIFont.PFSC_R(ofSize: 13) // 字体大小
        let maxHeight = 26.0 // 最大宽度限制
        
        // 创建NSAttributedString对象并设置属性
        let attributes = [NSAttributedString.Key.font: font] as [NSAttributedString.Key: Any]
        _ = NSMutableAttributedString(string: text, attributes: attributes)
         
        // 根据指定的最大宽度和字体大小计算文本的高度
        let size = (text as NSString).boundingRect(with: CGSize(width: .greatestFiniteMagnitude, height: maxHeight), options: .usesLineFragmentOrigin, attributes: attributes, context: nil).size
        
        let itemWidth = size.width + 20.0 // 计算单元格宽度的逻辑
        let itemHeight = 26.0 // 计算单元格高度的逻辑
        return CGSize(width: itemWidth, height: itemHeight)
    }
}

class YHSelectLookHeadViewCollectionViewCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHLifeSectionCollectionViewCell"
 
    func setSelectedStyle() {
        descripeLable.textColor = UIColor.brandMainColor
        descripeLable.backgroundColor = UIColor(hex: 0xebf0f9)
    }
 
    func setDeSelectedStyle() {
        descripeLable.textColor = UIColor(hex: 0x435163)
        descripeLable.backgroundColor = UIColor(hex: 0xf8f9fb)
    }
    
    var dataSource: String? {
        didSet {
            updataAllSubViews()
        }
    }
    
    lazy var descripeLable: UILabel = {
        let label = UILabel()
        label.text = "赴港"
        label.textColor = UIColor(hex: 0x94a3bb)
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textAlignment = .center
        return label
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    private func setupUI() {
        contentView.addSubview(descripeLable)
        descripeLable.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
    }
    
    func updataAllSubViews() {
        guard let dataSource = dataSource else { return }
        descripeLable.text = dataSource
    }
    
}
