//
//  YHMaterialListCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHMaterialListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHMaterialListCell"
    
    var rightBtnClick: (() -> Void)?
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        return view
    }()
    
    lazy var dotLine: YHDashLineView = {
        let view = YHDashLineView(strokeColor: UIColor.init(hex: 0xF7F2ED).cgColor, lineWidth: 0.8, lineDashPattern: [3, 3])
        return view
    }()
    
    lazy var markImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: "my_scheme_mark"))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "资料清单"
        return label
    }()
    
    lazy var tips1Label: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 4
    
        let a = NSMutableAttributedString(string: "这是您的资料清单，请您前往查看。请您在", attributes: [NSAttributedString.Key.foregroundColor: UIColor.mainTextColor, NSAttributedString.Key.font: UIFont.PFSC_R(ofSize: 14), NSAttributedString.Key.paragraphStyle: paragraphStyle])
        let b = NSMutableAttributedString(string: "1-2周内", attributes: [NSAttributedString.Key.foregroundColor: UIColor.init(hex: 0xD48638), NSAttributedString.Key.font: UIFont.PFSC_M(ofSize: 14), NSAttributedString.Key.paragraphStyle: paragraphStyle])
        let c = NSMutableAttributedString(string: "上传基础类证件哦，需要重新办理的可以晚些提供。需要注意的点如下：", attributes: [NSAttributedString.Key.foregroundColor: UIColor.mainTextColor, NSAttributedString.Key.font: UIFont.PFSC_R(ofSize: 14), NSAttributedString.Key.paragraphStyle: paragraphStyle])
        a.append(b)
        a.append(c)
        label.attributedText = a
        return label
    }()
    
    lazy var tips2Label: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .init(hex: 0x8993A2)
        label.numberOfLines = 0
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 4
        let attributes = [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        label.attributedText = NSAttributedString(string: "(1)港澳通如未办理，请优先安排办理；\n(2)如为国内学校，需准备由教育部学信网出具的学位认证报告；\n(3)如为海外学校，需准备官方成绩单和第三方机构学位认证文件；\n(4)赴港同意书，在获批后1个月内，由您获批时在职公司盖章出具即可（目前不需要提供）。", attributes: attributes)
        
        return label
    }()
    
    lazy var rightBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
        button.backgroundColor = UIColor(hex: 0xd48638).withAlphaComponent(0.08)
        button.contentHorizontalAlignment = .center
        button.setTitle("资料清单", for: .normal)
        button.setImage(UIImage(named: "scheme_button_icon"), for: .normal)
        button.setTitleColor(UIColor(hex: 0xd48638), for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.YH_clickEdgeInsets = UIEdgeInsets(top: 0, left: 20, bottom: 20, right: 20)
        button.addTarget(self, action: #selector(didRightBtnClicked), for: .touchUpInside)
        return button
    }()
    
    @objc func didRightBtnClicked() {
        rightBtnClick?()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.clipsToBounds = true
        
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(dotLine)
        whiteContentView.addSubview(markImgV)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(tips1Label)
        whiteContentView.addSubview(tips2Label)
        whiteContentView.addSubview(rightBtn)

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.bottom.equalToSuperview()
        }
        
        dotLine.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(0)
            make.height.equalTo(1)
        }
        
        markImgV.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.width.equalTo(4)
            make.height.equalTo(16)
            make.centerY.equalTo(titleLabel)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(26)
            make.height.equalTo(24)
            make.left.equalTo(markImgV.snp.right).offset(8)
            make.right.equalTo(-24)
        }
        
        tips1Label.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(titleLabel.snp.bottom).offset(18)
        }
        
        tips2Label.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(tips1Label.snp.bottom).offset(6)
            make.bottom.equalTo(-26)
        }
        
        rightBtn.snp.makeConstraints { make in
            make.width.equalTo(76)
            make.height.equalTo(27)
            make.right.equalTo(-24)
            make.top.equalTo(titleLabel)
        }
        rightBtn.iconInRight(with: 2)

    }

}
