//
//  YHHKRecordsTitleCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsTitleCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHHKRecordsHeaderCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 17)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(_ title: String?) {
        infoTitleLabel.text = title
    }

}

extension YHHKRecordsTitleCell {
    
    private func setupUI() {
        updateCellCorner(.top)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(bottomLineView)
        bottomLineView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-12)
        }
    }
}
