//
//  YHForwardArriveHKAlertView.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHForwardArriveHKAlertView: UIView {

    var confirmBlock: ((Bool) -> Void)?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0x000000, alpha: 0.68)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "提前到港"
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var messageLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let a = ASAttributedString.init("若申请人已提前到达香港，", .font(UIFont.PFSC_R(ofSize: 15)), .foreground(UIColor.mainTextColor70))
        let b = ASAttributedString.init("需先修改预约递交时间后再【确认在港】", .font(UIFont.PFSC_B(ofSize: 15)), .foreground(UIColor.brandMainColor))
        let c = ASAttributedString.init("，请确认是否提前到港？", .font(UIFont.PFSC_R(ofSize: 15)), .foreground(UIColor.mainTextColor70))
        label.attributed.text = a+b+c
        return label
    }()
    
    lazy var falseBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.backgroundColor =  UIColor.brandMainColor
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.setTitle("否".local, for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
        return button
    }()
    
    lazy var sureBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.backgroundColor =  UIColor.white
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.setTitle("是".local, for: .normal)
        button.setTitleColor( UIColor.brandMainColor, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.layer.borderWidth = 1
        button.layer.borderColor = UIColor.brandMainColor.cgColor
        button.addTarget(self, action: #selector(agree), for: .touchUpInside)
        return button
    }()
    
    static func alertView() -> YHForwardArriveHKAlertView {
        let view = YHForwardArriveHKAlertView(frame: UIScreen.main.bounds)
        return view
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func agree() {
        confirmBlock?(true)
        dismiss()
    }
    
    @objc func disagree() {
        confirmBlock?(false)
        dismiss()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(messageLabel)
        whiteContentView.addSubview(sureBtn)
        whiteContentView.addSubview(falseBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.height.equalTo(0.5)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(lineView.snp.bottom).offset(16)
        }
        
        sureBtn.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.equalTo(messageLabel.snp.bottom).offset(21)
            make.height.equalTo(45)
            make.width.equalTo(falseBtn.snp.width)
            make.right.equalTo(falseBtn.snp.left).offset(-10)
            make.bottom.equalTo(-16)
        }
        
        falseBtn.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.centerY.equalTo(sureBtn)
            make.height.equalTo(45)
        }
    }
}
