//
//  YHCertificateInfoController.swift
//  galaxy
//
//  Created by edy on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateInfoController: YHBaseViewController, YHFamilyMemberProtol {

    var familyMember: YHFamilyMember?
    var mainApplicantInfo: YHMyMainApplicantInfoModel?

    weak var delegate: YHSpouseInfoVCProtocol?
    var items: [[YHFormItemProtocol]] = [[YHFormItemProtocol]]()
    // 是否显示未填写错误提示
    var isNeedShowError = false
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame: .zero, style: .grouped)

        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.estimatedSectionHeaderHeight = 14.0
        tableView.estimatedSectionFooterHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor(hexString: "#F8F8F8")
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHFormItemDoubleChoiceCell.self, forCellReuseIdentifier: YHFormItemDoubleChoiceCell.cellReuseIdentifier)
        tableView.register(YHFormItemInputTextCell.self, forCellReuseIdentifier: YHFormItemInputTextCell.cellReuseIdentifier)
        tableView.register(YHFormItemEnterDetailCell.self, forCellReuseIdentifier: YHFormItemEnterDetailCell.cellReuseIdentifier)
        tableView.register(YHFormItemTitleCell.self, forCellReuseIdentifier: YHFormItemTitleCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemSelectSheetCell.self, forCellReuseIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier)
        tableView.register(YHFormItemExpireDateCell.self, forCellReuseIdentifier: YHFormItemExpireDateCell.cellReuseIdentifier)
        
        return tableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navigationBar.isHidden = true
        view.backgroundColor = UIColor(hexString: "#F8F8F8")
        createUI()
        loadInfo()
    }
    
    func createUI() {
        
        view.addSubview(tableView)
        let topHeight = k_Height_NavigationtBarAndStatuBar+YHStepView.height
        let bottomHeight = YHSaveAndSubmitView.height
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(KScreenHeight-topHeight-bottomHeight)
        }
        
        guard let familyMember = familyMember else { return }
        loadInfo()
    }
    
    // swiftlint:disable:next large_tuple
    func showLogic() -> (showHK: Bool, isHKMust: Bool, showPassport: Bool, isPassportMust: Bool) {
        
        guard let familyMember = familyMember else { return (false, false, false, false) }

        //        中国国籍&居住国内、中国国籍&居住国外不满一年
        //        1) 办理过港澳通
        //        证件上传：身份证+港澳通
        //        证件信息：港澳通行证必填(无身份证、护照)
        //
        //        2) 没办理过港澳通
        //        证件上传：身份证
        //        证件信息：港澳通行证非必填(无身份证、护照)
        //
        //        中国国籍&居住国外满一年
        //        证件上传：护照+身份证
        //        证件信息：护照必填(无身份证)
        //
        //        外籍国籍(无论是否在国外居住满一年)：
        //        证件上传：护照
        //        证件信息：仅护照且必填(无身份证)
                
        // 是否显示港澳通行证
        var showHK = false
        // 港澳通行证是否必填
        var isHKMust = false
        
        // 是否显示护照
        var showPassport = false
        // 护照是否必填
        var isPassportMust = false
        
        // 国籍
        let nationality = familyMember.nationality
        // 居住国外是否满一年
        var is_live_oversea_year = familyMember.isOverSeasOver1Year()
        // 居住国家
        var liveCountry = familyMember.address.country
        
        if familyMember.isLiveTother(), let mainApplicant = mainApplicantInfo { // 与主申请人同住用主申请人的居住信息判断
            liveCountry = mainApplicant.applicant_address.country
            is_live_oversea_year = mainApplicant.isOverSeasOver1Year()
        }
        
        if nationality == "中国-China" { // 中国国籍
            let isLiveInChina = liveCountry.contains("中国".local)
            if isLiveInChina { // 居住国内
                if familyMember.isHandled == 0 { // 没办理过港澳通行证
                    // 证件信息：港澳通行证非必填(无身份证、护照)
                    showHK = true
                    isHKMust = false
                    
                } else { // 办理过港澳通行证
                    // 证件信息：港澳通行证必填(无身份证、护照)
                    showHK = true
                    isHKMust = true
                }
                
            } else { // 居住国外
                if !is_live_oversea_year { // 居住国外不满一年
                    if familyMember.isHandled == 0 { // 没办理过港澳通行证
                        // 证件信息：港澳通行证非必填(无身份证、护照)
                        showHK = true
                        isHKMust = false
                        
                    } else { // 办理过港澳通行证
                        // 证件信息：港澳通行证必填(无身份证、护照)
                        showHK = true
                        isHKMust = true
                    }
                    
                } else { // 居住国外满一年
                    // 证件信息：护照必填(无身份证)
                    showPassport = true
                    isPassportMust = true
                }
            }
        } else { // 外国国籍
            //  证件信息：仅护照且必填(无身份证)
            showPassport = true
            isPassportMust = true
        }
        return (showHK, isHKMust, showPassport, isPassportMust)
    }
    
    func loadInfo() {
        guard let familyMember = familyMember else { return }
        items.removeAll()
        
        let a = showLogic()
        let showHK = a.showHK
        let isHKMust = a.isHKMust
        let showPassport = a.showPassport
        let isPassportMust = a.isPassportMust
        
        if showHK { // 显示港澳通行证
            let title1 = YHFormTitleItem(type: .hkAndMacaoPassport)
            let item10 = YHFormDetailItem(type: .traverlPassportNumber, isNeed: isHKMust, value: familyMember.certificates.hkMacaoPass.number, tips: "请输入证件号码".local)
            let item11 = YHFormDetailItem(type: .certificateSignPlace, isNeed: isHKMust, value: familyMember.certificates.hkMacaoPass.issueAt, tips: "请输入签发地".local)
            let item12 = YHFormDetailItem(type: .certificateSignDate, isNeed: isHKMust, value: familyMember.certificates.hkMacaoPass.issueDateStartAt, tips: "请选择签发日期".local)
            let item13 = YHFormDetailItem(type: .certificateValidDate, isNeed: isHKMust, value: familyMember.certificates.hkMacaoPass.issueDateEndAt, tips: "请选择届满日期".local)
            let arr1: [YHFormItemProtocol] = [title1, item10, item11, item12, item13]
            items.append(arr1)
        }
        
        if showPassport { // 显示护照
            let title2 = YHFormTitleItem(type: .passPortOrTravelInfo)
            let item21 = YHFormDetailItem(type: .certificateNumber, isNeed: isPassportMust, value: familyMember.certificates.passport.number, tips: "请输入证件号码".local)
            let item22 = YHFormDetailItem(type: .certificateSignPlace, isNeed: isPassportMust, value: familyMember.certificates.passport.issueAt, tips: "请输入签发地".local)
            let item23 = YHFormDetailItem(type: .certificateSignDate, isNeed: isPassportMust, value: familyMember.certificates.passport.issueDateStartAt, tips: "请选择签发日期".local)
            let item24 = YHFormDetailItem(type: .certificateValidDate, isNeed: isPassportMust, value: familyMember.certificates.passport.issueDateEndAt, tips: "请选择届满日期".local)
            let arr2: [YHFormItemProtocol] = [title2, item21, item22, item23, item24]
            items.append(arr2)
        }
     
        tableView.reloadData()
    }

}

extension YHCertificateInfoController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section >= items.count { return 0 }
        let arr = items[section]
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section >= items.count { return createDefaultCell(indexPath) }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return createDefaultCell(indexPath) }
        
        let item: YHFormItemProtocol = arr[indexPath.row]
        
        if item is YHFormTitleItem { // 标题
            guard let titleItem = item as? YHFormTitleItem else { return UITableViewCell() }
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemTitleCell.cellReuseIdentifier, for: indexPath) as? YHFormItemTitleCell else { return UITableViewCell() }
            
//            var isNeedText = ""
//            if titleItem.type == .chinaIdCardInfo {
//                if let familyMember = familyMember {
//                    let isChinaCardMust = familyMember.isChinese() && familyMember.relationType != .child
//                    isNeedText = isChinaCardMust ? "(必填)" : "(选填)"
//                }
//                
//            } else if titleItem.type == .hkAndMacaoPassport {
//                if let familyMember = familyMember {
//                    isNeedText = familyMember.isNeedHandleHKPassPort() ? "(必填)" : "(选填)"
//                }
//                
//            } else if titleItem.type == .passPortOrTravelInfo {
//                if let familyMember = familyMember {
//                    let isPassPortMust = !familyMember.isChinese()
//                    isNeedText = isPassPortMust ? "(必填)" : "(选填)"
//                }
//            }
            
            var title = item.getTitle()
//            if isNeedText.isEmpty {
//                title = item.getTitle()
//            } else {
//                title = "\(item.getTitle())\(isNeedText)"
//            }
            cell.setTitleAndSubTitle(title: title)
            return cell
        }
        
        if item is YHFormDetailItem {
            
            guard let detailItem = item as? YHFormDetailItem else { return UITableViewCell() }
            guard let title = arr[0] as? YHFormTitleItem else { return UITableViewCell() }
            
            if detailItem.type == .chinaIdentityCardNumber || detailItem.type == .certificateSignPlace || detailItem.type == .traverlPassportNumber || detailItem.type == .certificateNumber { // 证件号码和签发地需要填写
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemInputTextCell.cellReuseIdentifier, for: indexPath) as? YHFormItemInputTextCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.placeHolder = detailItem.placeHolder
                cell.title = detailItem.getTitle()
                cell.text = detailItem.value
                if detailItem.type == .chinaIdentityCardNumber {
                    cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isNeed && detailItem.value?.count != 18)
                } else {
                    cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isNeed && detailItem.isShowTips)
                }
                
                cell.textInputCondtion = {
                    textField in
                    
                    var max = -1
                    if detailItem.type == .chinaIdentityCardNumber { // 身份证
                        max = 18
                    } else if detailItem.type == .certificateSignPlace { // 签发地
                        max = 50
                    } else if detailItem.type == .traverlPassportNumber ||
                              detailItem.type == .certificateNumber {
                        max = 50
                    }

                    if max > 0 {
                        if let textStr = textField.text {
                            textField.text = (textStr.count > max ? textStr[safe: ..<max] : textStr)
                        }
                    }
                    return true
                }
                cell.textChange = {
                    [weak self] (text, isEditEnd) in
                    guard let self = self else { return }
                    
                    if detailItem.type == .chinaIdentityCardNumber {
                        self.familyMember?.certificates.cnIdentityCard.number = text ?? ""
                        
                    } else if detailItem.type == .traverlPassportNumber {
                        self.familyMember?.certificates.hkMacaoPass.number = text ?? ""
                        
                    } else if detailItem.type == .certificateNumber {
                        self.familyMember?.certificates.passport.number = text ?? ""
                        
                    } else if detailItem.type == .certificateSignPlace { // 签发地
                        
                            if title.type == .chinaIdCardInfo {
                                self.familyMember?.certificates.cnIdentityCard.issueAt = text ?? ""
                                
                            } else if title.type == .hkAndMacaoPassport {
                                self.familyMember?.certificates.hkMacaoPass.issueAt = text ?? ""

                            } else if title.type == .passPortOrTravelInfo {
                                self.familyMember?.certificates.passport.issueAt = text ?? ""
                            }
                    }
                    if isEditEnd {
                        self.loadInfo()
                        self.save()
                    }
                }
                return cell
            }
            
            if detailItem.type == .certificateType || detailItem.type == .certificateSignDate {
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier, for: indexPath) as? YHFormItemSelectSheetCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.detail = detailItem.value
                cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isNeed && detailItem.isShowTips)
                return cell
            }
            
            if detailItem.type == .certificateValidDate { // 届满日期
                
                if title.type == .chinaIdCardInfo { // 身份证
                    guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemExpireDateCell.cellReuseIdentifier, for: indexPath) as? YHFormItemExpireDateCell else { return UITableViewCell() }
                    cell.isMust = detailItem.isNeed
                    cell.title = detailItem.getTitle()
                    cell.detail = (detailItem.value == YHCNIdentityCard.longTime ? "" : detailItem.value)
                    cell.isLongTime = (detailItem.value == YHCNIdentityCard.longTime)
                    cell.clickBlock = {
                        [weak self] isLongTime in
                        guard let self = self else { return }
                        if title.type == .chinaIdCardInfo {
                            guard let familyMember = familyMember else { return }
                            familyMember.certificates.cnIdentityCard.issueDateEndAt = (isLongTime ? YHCNIdentityCard.longTime : familyMember.certificates.cnIdentityCard.lastIssueDateEndAt)
                            loadInfo()
                            save()
                        }
                    }
                    cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isNeed && detailItem.isShowTips)
                    return cell
                    
                }
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier, for: indexPath) as? YHFormItemSelectSheetCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.detail = detailItem.value
                cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isNeed && detailItem.isShowTips)
                return cell
            }
        }
        
        return createDefaultCell(indexPath)
    }
    
    func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        
        if indexPath.section >= items.count { return  }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return }
        createCorner(cell: cell, arr: arr, indexPath: indexPath)
    }
    
    func createDefaultCell(_ indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 1.0
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 14.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        if !(0..<items.count).contains(indexPath.section) { return }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if !(0..<arr.count).contains(indexPath.row) {  return  }
        let item = arr[indexPath.row]
        
        if item is YHFormTitleItem {
            return
        }
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return }
            guard let titleItem = arr[0] as? YHFormTitleItem else { return }
            
            if detailItem.type == .certificateValidDate ||
               detailItem.type == .certificateSignDate { // 届满日期 签发日期
                
                var title = ""
                var lastIsTaday = false
                if detailItem.type == .certificateValidDate {
                    title = "选择届满日期"
                    lastIsTaday = false
                } else if detailItem.type == .certificateSignDate {
                    title = "选择签发日期"
                    lastIsTaday = true
                }
                
                self.view?.endEditing(true)
                
                guard let familyMember = self.familyMember else { return }
                var timeString = ""
                var certificate = familyMember.certificates.cnIdentityCard
                if titleItem.type == .chinaIdCardInfo {
                    certificate = familyMember.certificates.cnIdentityCard
                    
                } else if titleItem.type == .hkAndMacaoPassport {
                    certificate = familyMember.certificates.hkMacaoPass
                    
                } else if titleItem.type == .passPortOrTravelInfo {
                    certificate = familyMember.certificates.passport
                }
                
                if detailItem.type == .certificateSignDate { // 选择签发日期
                    timeString = certificate.issueDateStartAt

                } else if detailItem.type == .certificateValidDate { // 届满日期
                    timeString = certificate.issueDateEndAt
                }
                
                YHDatePickView.show(type: .yyyymmdd, title: title, lastIsTaday: lastIsTaday, currentDay: timeString) {
                    [weak self] dateStr  in
                    
                    print(dateStr)
                    guard let self = self else { return }
                    
                    let format = DateFormatter()
                    format.dateFormat = "yyyy-MM-dd"
                    if let selectDate = format.date(from: dateStr) {
                        let selectTimeInterval = selectDate.timeIntervalSince1970
                        let currentTimeInterval = Date().timeIntervalSince1970
                        if detailItem.type == .certificateSignDate { // 选择签发日期
                            // 签发日期须早于当前日期
                            if selectTimeInterval > currentTimeInterval {
                                YHHUD.flash(message: "签发日期不能晚于当前日期")
                                return
                            }
                            if !certificate.issueDateEndAt.isEmpty, let endDate = format.date(from: certificate.issueDateEndAt) {
                                let endTimeInterval = endDate.timeIntervalSince1970

                                if selectTimeInterval > endTimeInterval {
                                    YHHUD.flash(message: "签发日期不能晚于届满日期")
                                    return
                                }
                            }
                        }
                        
                        if detailItem.type == .certificateValidDate { // 届满日期
        
                            if !certificate.issueDateStartAt.isEmpty, let startDate = format.date(from: certificate.issueDateStartAt) {
                                let startTimeInterval = startDate.timeIntervalSince1970

                                if selectTimeInterval < startTimeInterval {
                                    YHHUD.flash(message: "届满日期不能早于签发日期")
                                    return
                                }
                            }
                        }
                    }
                    
                    changeCertificateDate(certificate, type: detailItem.type, date: dateStr)
                    self.loadInfo()
                    save()
                }
            } else if detailItem.type == .certificateType { // 选择证件类别
                
//                let type = self.familyMember?.certificates.passport.passPortType ?? 3
//                YHSheetPickerView.show(type: .certificate, selectIndex:type) {
//                    [weak self] selectItem in
//                    guard let self = self else { return }
//                    self.familyMember?.certificates.passport.passPortType = selectItem.index
//                    self.loadInfo()
//                    self.save()
//                }
            }
            return
        }
    }
    
    func changeCertificateDate(_ certificate: YHCNIdentityCard?, type: YHFormDetailItemType, date: String?) {
        if type == .certificateSignDate {
            certificate?.issueDateStartAt = date ?? ""
            
        } else if type == .certificateValidDate {
            certificate?.issueDateEndAt = date ?? ""
        }
    }
        
    func createCorner(cell: UITableViewCell, arr: [Any], indexPath: IndexPath) {
        // 复用时需清理
        cell.layer.mask = nil
        // 设置每块section圆角
        if indexPath.row == 0 {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            
        } else if indexPath.row == arr.count-1 {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            
        } else {
            cell.layer.mask = nil
        }
    }
    
    func save() {
        if let delegate = delegate, delegate.responds(to: #selector(YHSpouseInfoVCProtocol.saveInfoSilent)) {
            delegate.saveInfoSilent()
        }
    }
    
    // 检查填写信息完整性
    func checkIntegrity() -> Bool {
        
        guard let familyMember = familyMember else { return false}
    
        let a = showLogic()
        let showHK = a.showHK
        let isHKMust = a.isHKMust
        let showPassport = a.showPassport
        let isPassportMust = a.isPassportMust
        
        if showHK, isHKMust {
            
            if familyMember.certificates.hkMacaoPass.number.count <= 0
                || familyMember.certificates.hkMacaoPass.issueAt.count <= 0
                || familyMember.certificates.hkMacaoPass.issueDateStartAt.count <= 0
                || familyMember.certificates.hkMacaoPass.issueDateEndAt.count <= 0 {
                return false
            }
        }
        
        if showPassport, isPassportMust {
            if familyMember.certificates.passport.number.count <= 0
                || familyMember.certificates.passport.issueAt.count <= 0
                || familyMember.certificates.passport.issueDateStartAt.count <= 0
                || familyMember.certificates.passport.issueDateEndAt.count <= 0 {
                return false
            }
            
        }
        return true
    }
    
    func nextStep() -> Bool {
        let isChecked = checkIntegrity()
        isNeedShowError = !isChecked
        
        loadInfo()
        
        if !isChecked {
            YHHUD.flash(message: "资料还未填完")
            return false
        }
        return true
    }
}
