//
//  YHPersonInfoControllerHoldViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHPreviewControllerHoldViewController: UIViewController {
    
    var canScroll: Bool = false {
        didSet {
            for vc in arrItemVCs {
                vc.vcCanScroll = canScroll
            }
        }
    }
    
    var myDefaultNavItemIndex: Int = 0 {
        didSet {
            self.segmentedView.selectItemAt(index: self.myDefaultNavItemIndex)
        }
    }
    
    let arrItemTitles = ["主申请人信息", "家庭成员信息", "基本资料", "学历/专业资格", "工作经验", "收入记录", "其他信息"]
    var arrItemVCs: [YHPreviewBaseViewController] = []
    var segmentedView: JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 55))
    lazy var segmentedDataSource: JXSegmentedBaseDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 16)
        dataSource.titleSelectedColor = UIColor.labelTextColor2
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 16)
        dataSource.titleSelectedColor = UIColor.brandMainColor
        
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.itemSpacing = 21.5
        return dataSource
    }()
    
    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        
        do {
            // 主申请人
            let vc = YHPreviewMainApplicantInfoViewController()
            arrItemVCs.append(vc)
        }
        do {
            // 家庭成员信息
            let vc = YHPreviewFamilyMemberViewController()
            arrItemVCs.append(vc)
        }
        do {
            // 基本资料
            let vc = YHPreviewBasiceInformationViewController()
            arrItemVCs.append(vc)
        }
        do {
            // 学历/专业资格
            let vc = YHPreviewAcademicAndProfessionalQualificationViewController()
            arrItemVCs.append(vc)
        }
        do {
            // 工作经验
            let vc = YHPreviewWorkExpViewController()
            arrItemVCs.append(vc)
        }
        
        do {
            // 收入记录
            let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") as? Int ?? 0
            let vc = YHPreviewIncomeRecordViewController(orderId: orderID)
            arrItemVCs.append(vc)
        }
        
        do {
            // 其他信息
            let vc = YHPreviewOtherInformationViewController()
            arrItemVCs.append(vc)
        }
        
        // segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        view.addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        
        // 分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        // 配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorHeight = 4
        indicator.indicatorCornerRadius = 2
        indicator.verticalOffset = 4
        indicator.indicatorColor = UIColor.brandMainColor
        segmentedView.indicators = [indicator]
        
        segmentedView.defaultSelectedIndex = self.myDefaultNavItemIndex
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()

        segmentedView.frame = CGRect(x: 0, y: 0, width: view.bounds.size.width, height: 55)
        listContainerView.frame = CGRect(x: 0, y: 55, width: view.bounds.size.width, height: view.bounds.size.height - 55)
        segmentedView.backgroundColor = .white
    }
}

extension YHPreviewControllerHoldViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        NotificationCenter.default.post(name: Notification.Name(rawValue: "scrollViewDidEndDragging0"), object: nil)
    }

    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
        NotificationCenter.default.post(name: Notification.Name(rawValue: "scrollViewWillBeginDragging0"), object: nil)
    }
}

extension YHPreviewControllerHoldViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index] as JXSegmentedListContainerViewListDelegate
    }
}
