//
//  YHMySettingCell.swift
//  galaxy
//
//  Created by edy on 2024/2/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySettingCell: UITableViewCell {

    static let cellReuseIdentifier = "YHMySettingCell"
    var isShowRedPoint: Bool = false {
        didSet {
            redPointView.isHidden = !isShowRedPoint
        }
    }
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString: "#141414")
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 15)
        label.setContentCompressionResistancePriority(.required, for: .horizontal)
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString: "#141414")
        label.textAlignment = .right
        label.font = UIFont.PFSC_R(ofSize: 15)
        return label
    }()
    
    private lazy var redPointView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = kCornerRadius3
        view.backgroundColor = .failColor
        view.isHidden = true
        return view
    }()
    
    lazy var arrowImgView: UIImageView = {
        let arrowImgView = UIImageView(image: UIImage(named: "mine_arrow_right"))
        return arrowImgView
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        contentView.addSubview(redPointView)
        contentView.addSubview(arrowImgView)
        
        titleLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(20)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.right.equalTo(arrowImgView.snp.left).offset(-4)
            make.centerY.equalToSuperview()
            make.left.equalTo(redPointView.snp.right).offset(4)
        }
        
        redPointView.snp.makeConstraints { make in
            make.width.height.equalTo(6)
            make.centerY.equalToSuperview()
            make.left.greaterThanOrEqualTo(titleLabel.snp.right).offset(4)
        }

        arrowImgView.snp.makeConstraints { make in
            make.width.equalTo(20)
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.right.equalTo(contentView).offset(-20)
        }
    }

}
