//
//  YHHomeIdentityCell.swift
//  galaxy
//
//  Created by edy on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeIdentityCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHHomeIdentityCell"
    var image: UIImage? = UIImage(named: "global_default_image") {
        didSet {
            if let img = image {
                imgView.image = img

            } else {
                imgView.image = UIImage(named: "global_default_image")
            }
        }
    }
    
    lazy var imgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "global_default_image"))
        view.clipsToBounds = true
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        self.selectionStyle = .none
        self.contentView.addSubview(self.imgView)
        self.imgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
