//
//  YHInvitationWithGiftsViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationWithGiftsViewController: YHBaseViewController {

    var tableView: UITableView!
    var bottomViewForShare: YHInvitationWithGiftsShareBottomView!
    var viewModel: YHInvitationWithGiftsViewModel = YHInvitationWithGiftsViewModel()
    
    lazy var headView: YHInvitationWithGiftsHeadView = {
        let headView = YHInvitationWithGiftsHeadView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 861.fix))
        return headView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        loadData()
    }
}

extension YHInvitationWithGiftsViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHInvitationWithGiftsSecondTableViewCell.self)
        cell.headData = self.viewModel.overviewModel
        cell.tableData = self.viewModel.recordModel
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if self.viewModel.recordModel.list.count == 0 {
            return 385
        } else if self.viewModel.recordModel.list.count <= 10 {
            return CGFloat(345 + 40 * self.viewModel.recordModel.list.count)
        } else {
            return 713
        }
      
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }

    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
}

extension YHInvitationWithGiftsViewController {
    func getData() {
        
    }
    
    func updateDataSource() {
        
    }
    
    func setView() {
        view.backgroundColor = .contentBkgColor
        let rightButtonItem = UIBarButtonItem(title: "规则", style: .plain, target: self, action: #selector(lookDeatil))
        rightButtonItem.setTitleTextAttributes([.foregroundColor: UIColor.mainTextColor], for: .normal)
        rightButtonItem.setTitleTextAttributes([.foregroundColor: UIColor.mainTextColor], for: .highlighted)
        gk_navRightBarButtonItem = rightButtonItem
        gk_navItemRightSpace = 16
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.showsHorizontalScrollIndicator = false
            tableView.showsVerticalScrollIndicator = false
            tableView.dataSource = self
            tableView.delegate = self
            tableView.tableHeaderView = headView
            tableView.tableFooterView = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.01))
            tableView.register(cellWithClass: YHInvitationWithGiftsFirstTableViewCell.self)
            tableView.register(cellWithClass: YHInvitationWithGiftsSecondTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.bottom.equalTo(-98)
        }
        
        bottomViewForShare = {
            let view = YHInvitationWithGiftsShareBottomView()
            view.block = { _ in
                let vc = YHInvatationShareViewController()
                self.navigationController?.pushViewController(vc)
            }
            return view
        }()
        view.addSubview(bottomViewForShare)
        bottomViewForShare.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(98)
        }
    }
    
    @objc func lookDeatil() {
        let view = YHInvitationWithGiftsDetailView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    func loadData() {
        viewModel.getCashOutRecord {[weak self] _, _ in
            guard let self = self else { return }
            self.headView.dataSource = self.viewModel.model
        }
        
        viewModel.getOverviewRecord {[weak self]  _, _ in
            guard let self = self else { return }
            self.tableView.reloadData()
        }
        
        viewModel.postRecord(page: 1) {[weak self] _, _ in
            guard let self = self else { return }
            self.tableView.reloadData()
        }
    }
}

extension YHInvitationWithGiftsViewController: UIScrollViewDelegate {
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        
        var percent = scrollView.contentOffset.y/k_Height_NavigationtBarAndStatuBar
        if percent < 0.0 {
            percent = 0.0
        } else if percent > 1.0 {
            percent = 1.0
        }
        gk_navBackgroundColor = UIColor(hex: 0xFFFFFF, alpha: percent)
        gk_navBarAlpha = 1
        
        if percent >= 0.5 {
            gk_navTitle = ""
        } else {
            gk_navTitle = ""
        }
    }
}
