//
//  YHInformationPerectModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInformationPerfectModel {
    var icon: String = ""
    var name: String = ""
    
    var helpModel: YHPersonInfoFillStepModel?
    var productType: Int = 0 // 0-优才  1-高才A 2-高才B 3-高才C
    
    var type: Int = -1 {
        didSet {
            
            isFirstCell = false
            isLastestCell = false
            
            if productType == 0 {
                // 优才
                if type == 0 {
                    isFirstCell = true
                    name = "主申请人信息"
                    icon = "zsqrxx_icon"
                } else if type ==  1 {
                    name = "家庭成员信息"
                    icon = "jtcyxx_icon"
                } else if type ==  2 {
                    name = "基本资料"
                    icon = "jbzl_icon"
                } else if type ==  3 {
                    name = "学历/专业资格"
                    icon = "xlzyzg_icon"
                } else if type ==  4 {
                    name = "工作经验"
                    icon = "gzjy_icon"
                } else if type == 5 {
                    name = "收入记录"
                    icon = "srjl_icon"
                } else if type ==  8 {
                    name = "其他信息"
                    icon = "qtxx_icon"
                    isLastestCell = true
                } else {
                    name = "未知"
                    icon = "qtxx_icon"
    //                isLastestCell = true
                }
                
            } else if productType == 1 {
                // 高A
                if type == 0 {
                    isFirstCell = true
                    name = "申请类别"
                    icon = "sqlb_icon"
                } else if type ==  1 {
                    name = "主申请人信息"
                    icon = "zsqrxx_icon"
                } else if type ==  2 {
                    name = "家庭成员信息"
                    icon = "jtcyxx_icon"
                } else if type ==  3 {
                    name = "收入记录/工作经验"
                    icon = "gzjy_icon"
                } else if type == 5 {
                    name = "基本资料"
                    icon = "jbzl_icon"
                } else {
                    name = "未知"
                    icon = "qtxx_icon"
    //                isLastestCell = true
                }
                
            } else if productType == 2 || productType == 3 {
                // 高BC
                if type == 0 {
                    isFirstCell = true
                    name = "申请类别"
                    icon = "sqlb_icon"
                } else if type == 1 {
                    name = "主申请人信息"
                    icon = "zsqrxx_icon"
                } else if type == 2 {
                    name = "家庭成员信息"
                    icon = "jtcyxx_icon"
                } else if type == 3 {
                    name = "学历资格"
                    icon = "xlzyzg_icon"
                } else if type == 4 {
                    name = "工作经验"
                    icon = "gzjy_icon"
                } else if type == 5 {
                    name = "基本资料"
                    icon = "jbzl_icon"
                } else {
                    name = "未知"
                    icon = "qtxx_icon"
    //                isLastestCell = true
                }
                
            }
        }
    }
    
    var status: String = ""
    var color: UIColor = .failColor
    var statusColor: UIColor = .failColor
    var isFinished: Bool = false {
        didSet {
            if let helpModel = helpModel, helpModel.policy_switch {
                
                if helpModel.step == 6 {
                    status = "去修改"
                    color = .mainTextColor
                    statusColor = .brandMainColor
                    if type != 1 {
                        icon = isFinished ? icon : icon
                    }
                    
                } else {
                    
                    status = isFinished ? "已完成" : "去修改"
                    color = isFinished ? UIColor.mainTextColor : UIColor.labelTextColor2
                    statusColor = isFinished ? UIColor.successColor : UIColor.labelTextColor2
                    if type != 1 {
                        icon = isFinished ? icon : icon
                    }
                }
            } else {
                status = isFinished ? "已完成" : "待完善"
                color = isFinished ? UIColor.mainTextColor : UIColor.labelTextColor2
                statusColor = isFinished ? UIColor.successColor : UIColor.labelTextColor2
                if type != 1 {
                    icon = isFinished ? icon : icon
                }
            }
        }
    }
    
    var isDoing: Bool = false {
        didSet {
            color = isFinished ? UIColor.mainTextColor : UIColor.labelTextColor2
            statusColor = isDoing ? UIColor.brandMainColor : UIColor.labelTextColor2
            if type != 1 {
                icon = isDoing ? icon : (icon + "_grey")
            }
        }
    }
    var isFirstCell: Bool = false
    var isLastestCell: Bool = false
}
