//
//  YHTotalIncomeCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import AttributedString
import UIKit

class YHTotalIncomeCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHTotalIncomeCell"
    var didClickInfoButton: (() -> Void)?
    
    private lazy var topLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "总收入"
        return label
    }()

    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 20)
        label.textColor = .brandMainColor
        label.lineBreakMode = .byCharWrapping
        return label
    }()

    lazy var infoButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "gc_other_info_warning"), for: .normal)
        button.addTarget(self, action: #selector(infoButtonDidClick(_:)), for: .touchUpInside)
        let padding: CGFloat = 4
        button.contentEdgeInsets = UIEdgeInsets(top: padding,
                                                left: padding,
                                                bottom: padding,
                                                right: padding)
        return button
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func setupCellInfo(detail: ASAttributedString, cellType: YHResignRoundCellType = .bottom, showTopLine: Bool = true) {
        infoDetailLabel.attributed.text = detail
        updateCellCorner(cellType)
        topLineView.isHidden = !showTopLine
    }
}

extension YHTotalIncomeCell {
    @objc private func infoButtonDidClick(_ sender: UIButton) {
        didClickInfoButton?()
    }

    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(topLineView)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(infoButton)
        infoTitleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoButton.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        topLineView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
            make.top.equalToSuperview()
        }

        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
        }

        infoButton.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.right)
            make.centerY.equalTo(infoTitleLabel)
            make.width.height.equalTo(24)
        }

        infoDetailLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.centerY.equalTo(infoTitleLabel)
            make.left.greaterThanOrEqualTo(infoButton.snp.right).offset(10)
        }
    }
}
