//
//  YHGCMainApplicantInformationViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/12/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCMainApplicantInformationViewModel: YHBaseViewModel {
    var mainModel: YHMainInformationModel = YHMainInformationModel()
    
    override init() {
        super.init()
    }
    
    func getBaseDataSource(_ isShowPrompt: Bool) -> [YHSectionItemModel] {
        let item = YHItemModel(id: .id1, isNeed: true, title: "国家/地区", isUserKeyBoard: false, prompts: "请选择", message: mainModel.nationality, type: .country, isShowPrompts: isShowPrompt, alertMessage: "请选择国家/地区")
        let section = YHSectionItemModel(title: "国籍", models: [item])
        
        let item4 = YHItemModel(id: .id2, isNeed: true, title: "国家/地区", isUserKeyBoard: false, prompts: "请选择", message: mainModel.address.country, type: .country, isShowPrompts: isShowPrompt, alertMessage: "请选择国家/地区")
        var string = ""
        let array = mainModel.address.area
        for item in array {
            if string.count != 0 {
                string = string + "/" + item
            } else {
                string += item
            }
        }
        let item1 = YHItemModel(id: .id3, isNeed: true, title: "省市地区", isUserKeyBoard: false, prompts: "请选择", message: string, type: .address, isShowPrompts: isShowPrompt, alertMessage: "请选择省市地区")
        let item2 = YHItemModel(id: .id4, isNeed: true, title: "详细地址", isUserKeyBoard: true, prompts: "请填写小区、楼栋、单元室等", message: mainModel.address.details, isShowPrompts: isShowPrompt, alertMessage: "请填写小区、楼栋、单元室等")
        let item11 = YHItemModel(id: .id32, isNeed: true, title: "详细地址", isUserKeyBoard: true, prompts: "请填写国外居住地", message: mainModel.address.foreign, isShowPrompts: isShowPrompt, alertMessage: "请填写国外居住地")
        let item22 = YHItemModel(id: .id33, isNeed: true, title: "是否在海外居住一年及以上", isUserKeyBoard: false, prompts: "", message: "\(mainModel.is_live_oversea_year)", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择是否在海外居住满1年及以上")
        let item222 = YHItemModel(id: .id40, isNeed: true, title: "是否拥有现时定居国家/地区的永久居留身份", isUserKeyBoard: false, prompts: "", message: "\(mainModel.have_permanent_residency)", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择是否拥有现时定居国家/地区的永久居留身份")
        let item2222 = YHItemModel(id: .id41, isNeed: true, title: "海外居留开始时间", isUserKeyBoard: false, prompts: "请选择", message: mainModel.residence_time, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择海外居留开始时间")
        let section1 = YHSectionItemModel(title: "现居住地址", models: [item4, item1, item2])
        let section11 = YHSectionItemModel(title: "现居住地址", models: [item4, item11, item22])
        let section111 = YHSectionItemModel(title: "现居住地址", models: [item4, item11, item222])
        let section1111 = YHSectionItemModel(title: "现居住地址", models: [item4, item11, item222, item2222])
        let item3 = YHItemModel(id: .id5, isNeed: true, title: "是否办理过", isUserKeyBoard: false, prompts: "", message: "\(mainModel.is_handled)", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择是否办理过港澳通行证")
        let section2 = YHSectionItemModel(title: "港澳通行证", models: [item3])
        let addressCountry = mainModel.address.country
        let nationality = mainModel.nationality
        let is_live_oversea_year = mainModel.is_live_oversea_year
        let have_permanent_residency = mainModel.have_permanent_residency
        
        if nationality.contains("中国") && !addressCountry.contains("中国") {
            if have_permanent_residency == 1 {
                return [section, section111]
            } else if have_permanent_residency == 0 {
                if isOneYearAgo(yearMonth: mainModel.residence_time) {
                    return [section, section1111]
                } else {
                    return [section, section1111, section2]
                }
            } else {
                return [section, section111]
            }
        } else if (nationality.contains("中国") && addressCountry.contains("中国")) || (nationality.contains("中国") && is_live_oversea_year == 0) {
            if addressCountry.contains("中国") || addressCountry == "" {
                return [section, section1, section2]
            } else {
                return [section, section11, section2]
            }
        } else {
            if addressCountry.contains("中国") || addressCountry == "" {
                return [section, section1]
            } else {
                return [section, section11]
            }
        }
    }
    
    func getDocumentInformation(_ isShowPrompt: Bool) -> [YHSectionItemModel] {
        var flag = false
        let nationality = mainModel.nationality
        let is_live_oversea_year = mainModel.is_live_oversea_year
        if nationality.contains("中国-China") {
            flag = true
        }
        
        let item = YHItemModel(id: .id8, isNeed: flag, title: "身份证号码", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates.cn_identity_card.number, isShowPrompts: isShowPrompt, alertMessage: "请输入正确的身份证号码")
        let item1 = YHItemModel(id: .id9, isNeed: flag, title: "签发地", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates.cn_identity_card.issue_at, isShowPrompts: isShowPrompt, alertMessage: "请输入签发地")
        let item2 = YHItemModel(id: .id10, isNeed: flag, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates.cn_identity_card.issue_date_start_at, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择签发日期")
        let item3 = YHItemModel(id: .id11, isNeed: flag, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates.cn_identity_card.issue_date_end_at, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择届满日期")
        var section1String = ""
        if flag {
            section1String = "中国身份证"
        } else {
            section1String = "中国身份证(选填)"
        }
        let section = YHSectionItemModel(title: section1String, models: [item, item1, item2, item3])
        var section2String = ""
        if mainModel.is_handled == 1 {
            section2String = "港澳通行证"
            flag = true
        } else {
            section2String = "港澳通行证(选填)"
            flag = false
        }
        let item10 = YHItemModel(id: .id12, isNeed: flag, title: "证件号码", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates.hk_macao_pass.number, isShowPrompts: isShowPrompt, alertMessage: "请输入旅行证件号码")
        let item11 = YHItemModel(id: .id13, isNeed: flag, title: "签发地", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates.hk_macao_pass.issue_at, isShowPrompts: isShowPrompt, alertMessage: "请输入签发地")
        let item12 = YHItemModel(id: .id14, isNeed: flag, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates.hk_macao_pass.issue_date_start_at, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择签发日期")
        let item13 = YHItemModel(id: .id15, isNeed: flag, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates.hk_macao_pass.issue_date_end_at, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择届满日期")
        
        let section1 = YHSectionItemModel(title: section2String, models: [item10, item11, item12, item13])
        
        var section3String = ""
        if is_live_oversea_year == 1 || !nationality.contains("中国") {
            section3String = "护照"
            flag = true
        } else {
            section3String = "护照(选填)"
            flag = false
        }
        let item5 = YHItemModel(id: .id17, isNeed: flag, title: "证件号码", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates.passport.number, isShowPrompts: isShowPrompt, alertMessage: "请输入证件号码")
        let item6 = YHItemModel(id: .id18, isNeed: flag, title: "签发地", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates.passport.issue_at, isShowPrompts: isShowPrompt, alertMessage: "请输入签发地")
        let item7 = YHItemModel(id: .id19, isNeed: flag, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates.passport.issue_date_start_at, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择签发日期")
        let item8 = YHItemModel(id: .id20, isNeed: flag, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates.passport.issue_date_end_at, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择届满日期")
        
        let section2 = YHSectionItemModel(title: section3String, models: [item5, item6, item7, item8])
        
        let addressCountry = mainModel.address.country
        if (nationality.contains("中国-China") && addressCountry.contains("中国-China")) || (nationality.contains("中国-China") && is_live_oversea_year == 0) {
            return [section, section1]
        } else if nationality.contains("中国-China") && is_live_oversea_year == 1 {
            return [section, section2]
        } else if nationality.contains("中国") {
            if is_live_oversea_year == 1 {
                if mainModel.is_handled == 1 {
                    return [section1, section2]
                }
                return [section2]
            } else {
                return [section1]
            }
        } else {
            return [section2]
        }
    }
    
    func getDetailDataSource(_ isShowPrompt: Bool) -> [YHSectionItemModel] {
        let item = YHItemModel(id: .id21, isNeed: true, title: "主申请人姓名", isUserKeyBoard: true, prompts: "请输入", message: mainModel.username, isShowPrompts: isShowPrompt, alertMessage: "请输入主申请人姓名")
        let item1 = YHItemModel(id: .id22, isNeed: false, title: "曾用名", isUserKeyBoard: true, prompts: "请与户口本一致，若无则不填", message: mainModel.used_name, isShowPrompts: isShowPrompt)
        let item2 = YHItemModel(id: .id23, isNeed: false, title: "婚前姓氏", isUserKeyBoard: true, prompts: "如有则填写，仅支持输入字母", message: mainModel.surname, isShowPrompts: isShowPrompt)
        let item3 = YHItemModel(id: .id24, isNeed: true, title: "出生日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.birthday, type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择出生日期")
        let item4 = YHItemModel(id: .id25, isNeed: true, title: "出生国家/地区", isUserKeyBoard: false, prompts: nil, message: "\(mainModel.birth_place_aboard)", leftButtonString: "国内", rightButtonString: "国外", isShowPrompts: isShowPrompt, alertMessage: "请选择出生国家/地区")
        let item5 = YHItemModel(id: .id26, isNeed: true, title: "出生城市", isUserKeyBoard: true, prompts: "请输入", message: mainModel.birth_place.details, isShowPrompts: isShowPrompt, alertMessage: "请输入出生城市；")
        let item55 = YHItemModel(id: .id34, isNeed: true, title: "出生城市", isUserKeyBoard: true, prompts: "请输入", message: mainModel.birth_place.foreign, isShowPrompts: isShowPrompt, alertMessage: "请输入出生城市")
        let item6 = YHItemModel(id: .id27, isNeed: true, title: "性别", isUserKeyBoard: false, prompts: "请选择", message: "\(mainModel.sex )", type: .sex, alertMessage: "请选择性别")
        let item7 = YHItemModel(id: .id28, isNeed: true, title: "婚姻状况", isUserKeyBoard: false, prompts: "请选择", message: "\(mainModel.married )", type: .marry, isShowPrompts: isShowPrompt, alertMessage: "请选择婚姻状况")
        var item555 = item5
        if mainModel.birth_place_aboard == 1 {
            item555 = item55
        }
        let section = YHSectionItemModel(title: "主申请人信息", models: [item, item1, item2, item3, item4, item555, item6, item7])
        
        let item10 = YHItemModel(id: .id31, isNeed: true, title: "是否办理过", isUserKeyBoard: false, prompts: nil, message: "\(mainModel.has_hk_id )", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择")
        let item11 = YHItemModel(id: .id35, isNeed: true, title: "香港身份证号码", isUserKeyBoard: true, prompts: "请输入", message: mainModel.hk_id_number, isShowPrompts: isShowPrompt, alertMessage: "请输入香港身份证号码")
        let section2 = YHSectionItemModel(title: "香港身份证", models: [item10])
        let section22 = YHSectionItemModel(title: "香港身份证", models: [item10, item11])
        var section222 = section2
        if mainModel.has_hk_id == 1 {
            section222 = section22
        }
        return [section, section222]
    }
    
    func getIDCardDataSource(_ isShowPrompt: Bool) -> [YHSectionItemModel] {
        let item = YHItemModel(id: .id5, isNeed: true, title: "身份证", isUserKeyBoard: false, prompts: "请输入", message: nil, isShowPrompts: isShowPrompt)
        let section = YHSectionItemModel(title: "中国身份证(选填)", models: [item])
        let item1 = YHItemModel(id: .id6, isNeed: true, title: "港澳通行证(选填)", isUserKeyBoard: false, prompts: "请输入", message: nil, isShowPrompts: isShowPrompt)
        let section1 = YHSectionItemModel(title: "中国身份证(选填)", models: [item1])
        let item2 = YHItemModel(id: .id7, isNeed: true, title: "护照(选填)", isUserKeyBoard: false, prompts: "请输入", message: nil, isShowPrompts: isShowPrompt)
        let section2 = YHSectionItemModel(title: "护照(选填)", models: [item2])
        let addressCountry = mainModel.address.country
        let nationality = mainModel.nationality
        let is_live_oversea_year = mainModel.is_live_oversea_year
        if (nationality.contains("中国") && addressCountry.contains("中国")) || (nationality.contains("中国") && is_live_oversea_year == 0) {
            if mainModel.is_handled == 1 {
                return [section, section1]
            } else {
                return [section]
            }
        } else if nationality.contains("中国") && is_live_oversea_year == 1 {
            return [section, section2]
        } else if nationality.contains("中国") && !addressCountry.contains("中国") {
            if mainModel.is_handled == 1 {
                return [section, section1]
            } else {
                return [section]
            }
        } else {
            return [section2]
        }
    }
    
    func updateModel(_ item: YHItemModel) {
        guard let type = item.id else { return }
        switch type {
            
        case .id1:
            mainModel.nationality = item.message ?? ""
            mainModel.is_live_oversea_year = 0
        case .id2:
            mainModel.address.country = item.message ?? ""
            mainModel.is_live_oversea_year = 0
        case .id3:
            mainModel.address.area = item.value ?? []
        case .id4:
            mainModel.address.details = item.message ?? ""
        case .id5:
            mainModel.is_handled = item.value?.first?.int ?? 0
        case .id6:
            printLog("1")
        case .id7:
            printLog("1")
        case .id8:
            mainModel.certificates.cn_identity_card.number = item.message ?? ""
        case .id9:
            mainModel.certificates.cn_identity_card.issue_at = item.message ?? ""
        case .id10:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? "") {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let currentTimeInterval = Date().timeIntervalSince1970
                if selectTimeInterval > currentTimeInterval {
                    YHHUD.flash(message: "签发日期不能晚于当前日期")
                } else {
                    guard let endDate = format.date(from: mainModel.certificates.cn_identity_card.issue_date_end_at) else {
                        mainModel.certificates.cn_identity_card.issue_date_start_at = item.message ?? ""
                        return
                    }
                    let endTimeInterval = endDate.timeIntervalSince1970
                    if selectTimeInterval > endTimeInterval {
                        YHHUD.flash(message: "签发日期不能晚于届满日期")
                    } else {
                        mainModel.certificates.cn_identity_card.issue_date_start_at = item.message ?? ""
                    }
                }
            }
        case .id11:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? ""), let startDate = format.date(from: mainModel.certificates.cn_identity_card.issue_date_start_at) {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let startTimeInterval = startDate.timeIntervalSince1970
                if selectTimeInterval < startTimeInterval {
                    YHHUD.flash(message: "届满日期不能早于签发日期")
                } else {
                    mainModel.certificates.cn_identity_card.issue_date_end_at = item.message ?? ""
                }
            } else {
                mainModel.certificates.cn_identity_card.issue_date_end_at = item.message ?? ""
            }
        case .id12:
            mainModel.certificates.hk_macao_pass.number = item.message ?? ""
        case .id13:
            mainModel.certificates.hk_macao_pass.issue_at = item.message ?? ""
        case .id14:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? "") {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let currentTimeInterval = Date().timeIntervalSince1970
                if selectTimeInterval > currentTimeInterval {
                    YHHUD.flash(message: "签发日期不能晚于当前日期")
                } else {
                    guard let endDate = format.date(from: mainModel.certificates.hk_macao_pass.issue_date_end_at) else {
                        mainModel.certificates.hk_macao_pass.issue_date_start_at = item.message ?? ""
                        return
                    }
                    let endTimeInterval = endDate.timeIntervalSince1970
                    if selectTimeInterval > endTimeInterval {
                        YHHUD.flash(message: "签发日期不能晚于届满日期")
                    } else {
                        mainModel.certificates.hk_macao_pass.issue_date_start_at = item.message ?? ""
                    }
                }
            }
        case .id15:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? ""), let startDate = format.date(from: mainModel.certificates.hk_macao_pass.issue_date_start_at) {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let startTimeInterval = startDate.timeIntervalSince1970
                if selectTimeInterval < startTimeInterval {
                    YHHUD.flash(message: "届满日期不能早于签发日期")
                } else {
                    mainModel.certificates.hk_macao_pass.issue_date_end_at = item.message ?? ""
                }
            }
        case .id16:
            mainModel.certificates.passport.passport_type = item.value?.first?.int ?? 0
        case .id17:
            mainModel.certificates.passport.number = item.message ?? ""
        case .id18:
            mainModel.certificates.passport.issue_at = item.message ?? ""
        case .id19:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? "") {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let currentTimeInterval = Date().timeIntervalSince1970
                if selectTimeInterval > currentTimeInterval {
                    YHHUD.flash(message: "签发日期不能晚于当前日期")
                } else {
                    guard let endDate = format.date(from: mainModel.certificates.passport.issue_date_end_at) else {
                        mainModel.certificates.passport.issue_date_start_at = item.message ?? ""
                        return
                    }
                    let endTimeInterval = endDate.timeIntervalSince1970
                    if selectTimeInterval > endTimeInterval {
                        YHHUD.flash(message: "签发日期不能晚于届满日期")
                    } else {
                        mainModel.certificates.passport.issue_date_start_at = item.message ?? ""
                    }
                }
            }
        case .id20:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? ""), let startDate = format.date(from: mainModel.certificates.passport.issue_date_start_at) {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let startTimeInterval = startDate.timeIntervalSince1970
                if selectTimeInterval < startTimeInterval {
                    YHHUD.flash(message: "届满日期不能早于签发日期")
                } else {
                    mainModel.certificates.passport.issue_date_end_at = item.message ?? ""
                }
            }
        case .id21:
            mainModel.username = item.message ?? ""
        case .id22:
            mainModel.used_name = item.message ?? ""
        case .id23:
            mainModel.surname = item.message ?? ""
        case .id24:
            let format = DateFormatter()
            format.dateFormat = "yyyy-MM-dd"
            if let selectDate = format.date(from: item.message ?? "") {
                let selectTimeInterval = selectDate.timeIntervalSince1970
                let currentTimeInterval = Date().timeIntervalSince1970
                if selectTimeInterval > currentTimeInterval {
                    YHHUD.flash(message: "入学日期不能晚于当前日期")
                } else {
                    mainModel.birthday = item.message ?? ""
                }
            }
        case .id25:
            mainModel.birth_place_aboard = item.value?.first?.int ?? 0
        case .id26:
            mainModel.birth_place.details  = item.message ?? ""
        case .id27:
            mainModel.sex = item.value?.first?.int ?? 0
        case .id28:
            mainModel.married = item.value?.first?.int ?? 0
        case .id29:
            mainModel.mobile = item.message ?? ""
        case .id30:
            mainModel.email = item.message ?? ""
        case .id31:
            mainModel.has_hk_id = item.value?.first?.int ?? 0
        case .id32:
            mainModel.address.foreign = item.message ?? ""
        case .id33:
            mainModel.is_live_oversea_year = item.value?.first?.int ?? 0
            mainModel.is_handled = 0
        case .id34:
            mainModel.birth_place.foreign = item.message ?? ""
        case .id35:
            mainModel.hk_id_number = item.message ?? ""
        case .id36:
            printLog("不需要")
        case .id37:
            printLog("不需要")
        case .id38:
            printLog("不需要")
        case .id39:
            printLog("不需要")
        case .id40:
            mainModel.have_permanent_residency = item.value?.first?.int ?? 0
            if mainModel.have_permanent_residency == 1 {
                mainModel.is_live_oversea_year = 1
            } else {
                if isOneYearAgo(yearMonth: mainModel.residence_time) {
                    mainModel.is_live_oversea_year = 1
                } else {
                    mainModel.is_live_oversea_year = 0
                }
            }
        case .id41:
            mainModel.residence_time = item.message ?? ""
            if isOneYearAgo(yearMonth: mainModel.residence_time) {
                mainModel.is_live_oversea_year = 1
            } else {
                mainModel.is_live_oversea_year = 0
            }
        }
    }
    
    func isOneYearAgo(yearMonth: String) -> Bool {
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM"
        
        // 将字符串转换为日期
        guard let date = dateFormatter.date(from: yearMonth) else {
            return false // 如果日期格式不正确，返回 nil
        }
        
        // 获取当前日期
        let currentDate = Date()
        
        // 获取日历实例
        let calendar = Calendar.current
        
        // 计算一年前的日期
        if let oneYearAgo = calendar.date(byAdding: .year, value: -1, to: currentDate) {
            // 比较日期，判断是否大于一年
            return date < oneYearAgo
        }
        
        return false
    }
    
    func updateModel(_ type: YHCardType, isFront: Bool, url: String) {
        switch type {
        case .identity:
            if isFront {
                mainModel.certificates.cn_identity_card.img_front = url
            } else {
                mainModel.certificates.cn_identity_card.img_back = url
            }
        case .passport:
            if isFront {
                mainModel.certificates.hk_macao_pass.img_front = url
            } else {
                mainModel.certificates.hk_macao_pass.img_back = url
            }
        case .other:
            mainModel.certificates.passport.img_front = url
        }
    }
    
    func updateModel(_ model: YHHKIDCardModel) {
        if model.name.count != 0 {
            mainModel.username = model.name
        }
        if model.birth.count != 0 {
            mainModel.birthday = model.birth
        }
        if model.gender.count != 0 {
            if model.gender == "女" {
                mainModel.sex = 2
            } else {
                mainModel.sex = 1
            }
        }
        if model.term_begins.count != 0 {
            mainModel.certificates.hk_macao_pass.issue_date_start_at = model.term_begins
        }
        if model.end_of_term.count != 0 {
            mainModel.certificates.hk_macao_pass.issue_date_end_at = model.end_of_term
        }
        if model.IssueAddress.count != 0 {
            mainModel.certificates.hk_macao_pass.issue_at = model.IssueAddress
        }
        if model.card_num.count != 0 {
            mainModel.certificates.hk_macao_pass.number = model.card_num
        }
    }
    
    func updateModel(_ model: YHCNIDCardModel) {
        if model.name.count != 0 {
            mainModel.username = model.name
        }
        if model.birth.count != 0 {
            mainModel.birthday = model.birth
        }
        if model.gender.count != 0 {
            if model.gender == "女" {
                mainModel.sex = 2
            } else {
                mainModel.sex = 1
            }
        }
        if model.term_begins.count != 0 {
            mainModel.certificates.cn_identity_card.issue_date_start_at = model.term_begins
        }
        if model.end_of_term.count != 0 {
            mainModel.certificates.cn_identity_card.issue_date_end_at = model.end_of_term
        }
        if model.issuing_authority.count != 0 {
            mainModel.certificates.cn_identity_card.issue_at = model.issuing_authority
        }
        if model.card_num.count != 0 {
            mainModel.certificates.cn_identity_card.number = model.card_num
        }
    }
    
    func requestMainInformation(_ orderID: String, callBackBlock: @escaping (_ success: YHMainInformationModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.OrderInformation.getInformation
        let param: [String: Any] = ["order_id": orderID]
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMainInformationModel.deserialize(from: dic) else {
                    callBackBlock(nil, nil)
                    return
                }
                self.mainModel = result
                callBackBlock(result, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(nil, error)
            }
        } failBlock: { err in
            callBackBlock(nil, err)
        }
    }
    
    func updateMainInformation(_ saveType: YHSaveType, _ orderID: Int, _ step: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        var type = ""
        if saveType == .save {
            type = "save"
        } else {
            type = "submit"
        }
        let area: [String] = mainModel.address.area
        let birthArea: [String] = mainModel.birth_place.area
        let address = ["area": area,
                       "country": mainModel.address.country,
                       "details": mainModel.address.details,
                       "foreign": mainModel.address.foreign] as [String: Any]
        let birthPlace = ["area": birthArea,
                          "country": mainModel.birth_place.country,
                          "details": mainModel.birth_place.details,
                          "foreign": mainModel.birth_place.foreign] as [String: Any]
        let cnID = ["img_back": mainModel.certificates.cn_identity_card.img_back,
                    "img_front": mainModel.certificates.cn_identity_card.img_front,
                    "issue_at": mainModel.certificates.cn_identity_card.issue_at,
                    "issue_date_end_at": mainModel.certificates.cn_identity_card.issue_date_end_at,
                    "issue_date_start_at": mainModel.certificates.cn_identity_card.issue_date_start_at,
                    "number": mainModel.certificates.cn_identity_card.number] as [String: Any]
        let hkID = ["img_back": mainModel.certificates.hk_macao_pass.img_back,
                    "img_front": mainModel.certificates.hk_macao_pass.img_front,
                    "issue_at": mainModel.certificates.hk_macao_pass.issue_at,
                    "issue_date_end_at": mainModel.certificates.hk_macao_pass.issue_date_end_at,
                    "issue_date_start_at": mainModel.certificates.hk_macao_pass.issue_date_start_at,
                    "number": mainModel.certificates.hk_macao_pass.number] as [String: Any]
        let passport = ["img_back": mainModel.certificates.passport.img_back,
                        "img_front": mainModel.certificates.passport.img_front,
                        "issue_at": mainModel.certificates.passport.issue_at,
                        "issue_date_end_at": mainModel.certificates.passport.issue_date_end_at,
                        "issue_date_start_at": mainModel.certificates.passport.issue_date_start_at,
                        "number": mainModel.certificates.passport.number,
                        "passport_type": mainModel.certificates.passport.passport_type] as [String: Any]
        let country = mainModel.address.country
        if country.contains("中国") {
            mainModel.address_aboard = 0
        } else {
            mainModel.address_aboard = 1
        }
        let params: [String: Any] = ["address": address,
                    "address_aboard": mainModel.address_aboard,
                    "age": mainModel.age,
                    "birth_place": birthPlace,
                    "birth_place_aboard": mainModel.birth_place_aboard,
                    "birthday": mainModel.birthday,
                    "email": mainModel.email,
                    "has_hk_id": mainModel.has_hk_id,
                    "hk_id_number": mainModel.hk_id_number,
                    "id": mainModel.id,
                    "is_handled": mainModel.is_handled,
                    "is_live_oversea_year": mainModel.is_live_oversea_year,
                    "married": mainModel.married,
                    "mobile": mainModel.mobile,
                    "nationality": mainModel.nationality,
                    "order_id": orderID,
                    "sex": mainModel.sex,
                    "step": step,
                    "surname": mainModel.surname,
                    "used_name": mainModel.used_name,
                    "username": mainModel.username,
                    "save_type": type,
                    "have_permanent_residency": mainModel.have_permanent_residency,
                                      "residence_time": mainModel.residence_time,
                    "username_pinyin": ["family_name": mainModel.username_pinyin.family_name,
                                        "given_name": mainModel.username_pinyin.given_name],
                    "certificates": ["cn_identity_card": cnID,
                                    "hk_macao_pass": hkID,
                                    "passport": passport]
                    ]
//        let strUrl = "http://192.168.25.48:18088/" + YHAllApiName.OrderInformation.updateInformation
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.OrderInformation.updateInformation
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestCnIDCardMessage(_ url: String, isBack: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OCR.cn
        let params: [String: Any] = ["url": url,
                                      "is_back": isBack]
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHCNIDCardModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.updateModel(result)
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestHkIDCardMessage(_ url: String, isBack: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OCR.hk
        let params: [String: Any] = ["url": url,
                                      "is_back": isBack]
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHHKIDCardModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.updateModel(result)
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func isCanNext(_ step: Int) -> Bool {
        if step == 0 {
            let nationality = mainModel.nationality
            let country = mainModel.address.country
            let area = mainModel.address.area
            let details = mainModel.address.details
            let foreign = mainModel.address.foreign
            let residence_time = mainModel.residence_time
            let have_permanent_residency = mainModel.have_permanent_residency
            guard nationality.count > 0 else { return false }
            guard country.count > 0 else { return false }
            if country.contains("中国") {
                if nationality.contains("中国") {
                    guard area.count > 0 else { return false }
                    guard details.count > 0 else { return false }
                    return true
                } else {
                    guard have_permanent_residency > 0 else { return false }
                    if have_permanent_residency == 0 {
                        guard residence_time.count > 0 else { return false }
                    }
                    return true
                }
            } else {
                guard foreign.count > 0 else { return false }
                return true
            }
        } else if step == 1 {
            return true
        } else if step == 2 {
            let cn_identity_card_number = mainModel.certificates.cn_identity_card.number
            let cn_identity_card_issue_at = mainModel.certificates.cn_identity_card.issue_at
            let cn_identity_card_issue_date_start_at = mainModel.certificates.cn_identity_card.issue_date_start_at
            let cn_identity_card_issue_date_end_at = mainModel.certificates.cn_identity_card.issue_date_end_at
            let hk_macao_pass_number = mainModel.certificates.hk_macao_pass.number
            let hk_macao_pass_issue_at = mainModel.certificates.hk_macao_pass.issue_at
            let hk_macao_pass_issue_date_start_at = mainModel.certificates.hk_macao_pass.issue_date_start_at
            let hk_macao_pass_issue_date_end_at = mainModel.certificates.hk_macao_pass.issue_date_end_at
            let passport_number = mainModel.certificates.passport.number
            let passport_issue_at = mainModel.certificates.passport.issue_at
            let passport_issue_date_start_at = mainModel.certificates.passport.issue_date_start_at
            let passport_issue_date_end_at = mainModel.certificates.passport.issue_date_end_at
            let nationality = mainModel.nationality
            let is_live_oversea_year = mainModel.is_live_oversea_year
            let addressCountry = mainModel.address.country
            if (nationality.contains("中国-China") && addressCountry.contains("中国-China")) || (nationality.contains("中国-China") && is_live_oversea_year == 0) {
                guard cn_identity_card_number.count == 18 else { return false }
                guard cn_identity_card_issue_at.count > 0 else { return false }
                guard cn_identity_card_issue_date_start_at.count > 0 else { return false }
                guard cn_identity_card_issue_date_end_at.count > 0 else { return false }
                if mainModel.is_handled == 1 {
                    guard hk_macao_pass_number.count > 0 else { return false }
                    guard hk_macao_pass_issue_at.count > 0 else { return false }
                    guard hk_macao_pass_issue_date_start_at.count > 0 else { return false }
                    guard hk_macao_pass_issue_date_end_at.count > 0 else { return false }
                }
            } else if nationality.contains("中国-China") && is_live_oversea_year == 1 {
                guard cn_identity_card_number.count == 18 else { return false }
                guard cn_identity_card_issue_at.count > 0 else { return false }
                guard cn_identity_card_issue_date_start_at.count > 0 else { return false }
                guard cn_identity_card_issue_date_end_at.count > 0 else { return false }
                guard passport_number.count > 0 else { return false }
                guard passport_issue_at.count > 0 else { return false }
                guard passport_issue_date_start_at.count > 0 else { return false }
                guard passport_issue_date_end_at.count > 0 else { return false }
            } else if nationality.contains("中国") {
                if is_live_oversea_year == 1 {
                    guard passport_number.count > 0 else { return false }
                    guard passport_issue_at.count > 0 else { return false }
                    guard passport_issue_date_start_at.count > 0 else { return false }
                    guard passport_issue_date_end_at.count > 0 else { return false }
                }
                if mainModel.is_handled == 1 {
                    guard hk_macao_pass_number.count > 0 else { return false }
                    guard hk_macao_pass_issue_at.count > 0 else { return false }
                    guard hk_macao_pass_issue_date_start_at.count > 0 else { return false }
                    guard hk_macao_pass_issue_date_end_at.count > 0 else { return false }
                }
            } else {
                guard passport_number.count > 0 else { return false }
                guard passport_issue_at.count > 0 else { return false }
                guard passport_issue_date_start_at.count > 0 else { return false }
                guard passport_issue_date_end_at.count > 0 else { return false }
            }
            return true
        } else {
            let username = mainModel.username
            let birthday = mainModel.birthday
            let birth_place_aboard = mainModel.birth_place_aboard
            let birth_place_area = mainModel.birth_place.details
            let birth_place_foreign = mainModel.birth_place.foreign
            let sex = mainModel.sex
            _ = mainModel.married
            let has_hk_id = mainModel.has_hk_id
            let hk_id_numbe = mainModel.hk_id_number
            guard username.count > 0 else { return false }
            guard birthday.count > 0 else { return false }
            guard sex > 0 else { return false }
            if birth_place_aboard == 1 {
                guard birth_place_foreign.count > 0 else { return false }
            } else {
                guard birth_place_area.count > 0 else { return false }
            }
            if has_hk_id == 1 {
                guard hk_id_numbe.count > 0 else { return false }
            }
            return true
        }
    }
}
