//
//  YHLookPlanButton.swift
//  galaxy
//
//  Created by Dufet on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLookPlanButton: UIButton {

    lazy var title1Label: UILabel = {
        let lable = UILabel()
        lable.textColor = .white
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_M(ofSize: 16)
        lable.text = "查看定制方案"
        return lable
    }()
    
    lazy var title2Label: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0xFFFFFF, alpha: 0.6)
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 11)
        lable.text = "银河创世纪专业团队为您服务"
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        backgroundColor = .mainTextColor
        self.layer.cornerRadius = 3.0
        
        self.addSubview(title1Label)
        self.addSubview(title2Label)
        
        title1Label.snp.makeConstraints { make in
            make.top.equalTo(12)
            make.height.equalTo(22)
            make.centerX.equalToSuperview()
        }
        
        title2Label.snp.makeConstraints { make in
            make.top.equalTo(title1Label.snp.bottom).offset(0)
            make.height.equalTo(14)
            make.centerX.equalToSuperview()
        }
    }

}
