//
//  UIApplication-Extension.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/31.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit

extension UIApplication {
    
    func yhKeyWindow() -> UIWindow? {
        var originalKeyWindow: UIWindow?
#if swift(>=5.1)
        if #available(iOS 13, *) {
            originalKeyWindow = UIApplication.shared.connectedScenes
                .compactMap { $0 as? UIWindowScene }
                .flatMap { $0.windows }
                .first(where: { $0.isKeyWindow })
        } else {
            originalKeyWindow = UIApplication.shared.keyWindow
        }
#else
        originalKeyWindow = UIApplication.shared.keyWindow
#endif
        return originalKeyWindow
    }
}
