//
//  YHNoDataTipsView.swift
//  galaxy
//
//  Created by EDY on 2024/4/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHNoDataTipsView: UIView {

    private lazy var iconImgV: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "list_no_data")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    lazy var tipsLab: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.textAlignment = .center
        lable.text = "暂无"
        return lable
    }()
    
    public override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    private func initView() {
        addSubview(iconImgV)
        iconImgV.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.centerX.equalToSuperview()
            make.height.equalTo(93)
            make.width.equalTo(93)
        }
        
        addSubview(tipsLab)
        tipsLab.snp.makeConstraints { make in
            make.top.equalTo(iconImgV.snp.bottom).offset(12)
            make.centerX.equalToSuperview()
            make.left.right.equalToSuperview()
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
