//
//  YHCertificateUploadFailTipsView.swift
//  galaxy
//
//  Created by edy on 2024/3/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//
/*
 【Usage】
 YHCertificateUploadFailTipsView.tipsView().show()

 */

import UIKit

class YHCertificateUploadFailTipsView: UIView {

    lazy var blackMaskView: UIView = {
        let view = UIView(frame: UIScreen.main.bounds)
        view.backgroundColor = UIColor(hex: 0x0F1214, alpha: 0.5)
        let tap = UITapGestureRecognizer(target: self, action: #selector(dismiss))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var failIconImgView: UIImageView = {
        let imgV = UIImageView(image: UIImage(named: "my_cer_upload_fail"))
        return imgV
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "上传失败"
        return label
    }()
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .labelTextColor2
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.numberOfLines = 0
        label.text = "请检查文件格式是否为docx、jpg、doc、png、pptx、pdf".local
        return label
    }()
    
    lazy var knowBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("我知道了".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandMainColor
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
        return btn
    }()
    
    static func tipsView() -> YHCertificateUploadFailTipsView {
        let view = YHCertificateUploadFailTipsView(frame: UIScreen.main.bounds)
        return view
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        
        whiteContentView.addSubview(failIconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(tipsLabel)
        whiteContentView.addSubview(knowBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(38)
            make.right.equalToSuperview().offset(-38)
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        
        failIconImgView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(30)
            make.centerX.equalToSuperview()
            make.width.height.equalTo(53)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(24)
            make.top.equalTo(failIconImgView.snp.bottom).offset(16)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
        }
        
        knowBtn.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(21)
            make.right.equalToSuperview().offset(-21)
            make.height.equalTo(45)
            make.top.equalTo(tipsLabel.snp.bottom).offset(31)
            make.bottom.equalToSuperview().offset(-21)
        }
    }

}

extension YHCertificateUploadFailTipsView {
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
}
