//
//  YHVisaRenewalGuideRemarkCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalGuideRemarkCell: UITableViewCell {

    static let cellReuseIdentifier = "YHVisaRenewalGuideRemarkCell"
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor70
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(detail: String) {
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineHeightMultiple = 1.07
        let attributedText = NSAttributedString(
            string: detail,
            attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        )
        infoDetailLabel.attributedText = attributedText
    }

}

extension YHVisaRenewalGuideRemarkCell {
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(infoDetailLabel)
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(12)
            make.left.equalToSuperview().offset(20)
            make.right.lessThanOrEqualToSuperview().offset(-20)
            make.bottom.equalToSuperview()
        }
    }
}
