//
//  YHLookResignResultHeadView.swift
//  galaxy
//
//  Created by EDY on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHLookResignResultHeadView: UIView {
    var bgImageView: UIImageView!
    var titleImageView: UILabel!
    var messageLabel: UILabel!
    var state: Int = 0 {
        didSet {
            if state == 0 {
                bgImageView.image = UIImage(named: "look_resign_result_head_one")
//                titleImageView.image = UIImage(named: "look_resign_result_title_one")
                titleImageView.text = "续签审核中"
            } else if state == 1 {
                bgImageView.image = UIImage(named: "look_resign_result_head_two")
//                titleImageView.image = UIImage(named: "look_resign_result_title_two")
                titleImageView.text = "续签待补件"
            } else {
                bgImageView.image = UIImage(named: "look_resign_result_head_three")
//                titleImageView.image = UIImage(named: "look_resign_result_title_three")
                titleImageView.text = "续签已获批"
            }
        }
    }
    
    var dataSource: YHLookResignResultModel? {
        didSet {
            guard let dataSource = dataSource else { return }
            if state == 0 {
                let a = ASAttributedString.init("\(dataSource.data.user)，您的【优秀人才入境计划】续签申请资料已递交至港府，且港府", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                let b = ASAttributedString.init("已确认递交申请", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor))
                let c = ASAttributedString.init("，入境处审核周期预计4-8周，请耐心等待获批结果", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                messageLabel.attributed.text = a+b+c
            } else if state == 1 {
                let a = ASAttributedString.init("\(dataSource.data.user)，您的【优秀人才入境计划】续签申请已获得", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                let b = ASAttributedString.init("港府补件通知", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor))
                let c = ASAttributedString.init("，请您于\(dataSource.data.deadline)前根据补件信内容，补充资料递交至港府！", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                messageLabel.attributed.text = a+b+c
            } else {
                if dataSource.mode == 1 {
                    let a = ASAttributedString.init("\(dataSource.data.user)，您申请的【优秀人才入境计划】续签申请在\(dataSource.data.main.result_date)", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                    let b = ASAttributedString.init("正式获批", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor))
                    let c = ASAttributedString.init("！请在\(dataSource.data.main.pay_deadline)前，赴港缴费领取新签证！", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                    messageLabel.attributed.text = a+b+c
                } else {
                    let a = ASAttributedString.init("\(dataSource.data.user)，您与家人申请的【优秀人才入境计划】续签申请已", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                    let b = ASAttributedString.init("正式获批", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor))
                    let c = ASAttributedString.init("！请在截止时间前赴港缴费领取新签证", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
                    messageLabel.attributed.text = a+b+c
                }
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        self.layer.cornerRadius = 1
        self.layer.masksToBounds = true
        bgImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "resign_upload_doc_head")
            return imageView
        }()
        addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(298.fix)
        }
        
        titleImageView = {
            let imageView = UILabel()
            imageView.font = UIFont(name: "AlimamaShuHeiTi-Bold", size: 32)
            imageView.textColor = UIColor(hex: 0x001c48)
            return imageView
        }()
        addSubview(titleImageView)
        titleImageView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(20 + k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(39)
            make.width.equalTo(160)
        }
        
        messageLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            let a = ASAttributedString.init("欧阳先生，您的【优秀人才入境计划】续签申请资料已递交至港府，且港府", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.mainTextColor50))
            let b = ASAttributedString.init("已确认递交申请", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.brandMainColor))
            let c = ASAttributedString.init("，入境处审核周期预计4-8周，请耐心等待获批结果", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.mainTextColor50))
            label.attributed.text = a+b+c
            return label
        }()
        addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 71)
        }
    }

}
