//
//  YHResignAppointContainerViewController.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignAppointContainerViewController: YHBaseViewController {

    // 订单ID
    var orderId: Int = 0
    // 批次ID
    var renewalId: Int = 0
    
    let viewModel = YHResignAppointViewModel()
    
    lazy var appointVC: YHResignAppointTimeViewController = {
        let vc = YHResignAppointTimeViewController()
        vc.orderId = orderId
        vc.renewalId = renewalId
        vc.view.isHidden = true
        return vc
    }()
    
    lazy var scheduleVC: YHResignAppointScheduleListViewController = {
        let vc = YHResignAppointScheduleListViewController()
        vc.orderId = orderId
        vc.renewalId = renewalId
        vc.view.isHidden = true
        return vc
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        NotificationCenter.default.addObserver(self, selector: #selector(refreshList), name: YhConstant.YhNotification.didUpdateResignAppointStatusList, object: nil)
        
        self.addChild(appointVC)
        self.addChild(scheduleVC)
        
        self.view.addSubview(appointVC.view)
        self.view.addSubview(scheduleVC.view)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        requestData()
    }
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    @objc func refreshList() {
        requestData {
            self.scheduleVC.firstShowGuideSheetView()
        }
    }
    
    @objc func requestData(_ scheduleBlock: (() -> Void)? = nil) {
        
        YHHUD.show(.progress(message: "加载中..."))
        viewModel.getScheduleInfoList(renewalId: renewalId) {
            [weak self] success1, error1 in
            YHHUD.hide()
            guard let self = self else { return }
            if !success1 {
                let msg = error1?.errorMsg ?? "服务器未知错误"
                YHHUD.flash(message: msg)
                return
            }
            
            // 请求预约人员列表
            YHHUD.show(.progress(message: "加载中..."))
            self.viewModel.getResignAppointUserlist(renewalId: self.renewalId) {
                [weak self] success2, error2 in
                YHHUD.hide()
                guard let self = self else { return }
                
                if !success2 {
                    let msg = error2?.errorMsg ?? "服务器未知错误"
                    YHHUD.flash(message: msg)
                    return
                }
                
                let isNotAppointed = self.viewModel.scheduleInfoList.renewal_List.count <= 0
                if isNotAppointed { // 没有预约过
            
                    self.appointVC.allAppointUsers = self.viewModel.appointUsers
                    self.appointVC.view.isHidden = false
                    self.scheduleVC.view.isHidden = true
                    
                } else { // 预约过
                    self.scheduleVC.allAppointUsers = self.viewModel.appointUsers
                    self.scheduleVC.result_open = self.viewModel.scheduleInfoList.result_open
                    self.scheduleVC.scheduleArr = self.viewModel.scheduleInfoList.renewal_List
                    self.scheduleVC.isTogether = self.viewModel.scheduleInfoList.is_together
                    self.scheduleVC.view.isHidden = false
                    self.appointVC.view.isHidden = true
                    scheduleBlock?()
               }
            }
        }
    }
}
