//
//  YHDynamicListItem.swift
//  galaxy
//
//  Created by Dufet on 2025/9/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import SmartCodable
import UIKit

class YHDynamicListModel: SmartCodable {
    var total: Int = 0
    var page: Int = 0
    var pageSize: Int = 0
    var list: [YHDynamicItem] = []

    required init() {
    }
}

class YHResourceURLs: SmartCodable {
    var name: String = ""
    var url: String = ""
    var type: Int = 0
    var width: String = "0"
    var height: String = "0"

    required init() {
    }
}

class YHDynamicItem: SmartCodable {
    var id: String = "" // 动态id
    var user_id: String = ""
    var title: String = ""
    var content: String = ""
    var resource_urls: [YHResourceURLs] = []
    var visibility: Int = 0 // 0-未知 1-公开，2-好友可见，3-仅自己可见
    var audit_status: Int = 0 // 0-未知 1-待审核，2-审核通过，3-不通过
    var ai_audit_status: Int = 0 // 0-未知 1-待审核，2-审核通过，3-不通过
    var violation_reason: Int = 0 // 违规原因 0-未知
    var status: Int = 0 // 状态：0-未知 1-上架中 2-已下架
    var violation_remark: String = "" // 违规详情
    var ai_audit_remark: String = "" // ai审核依据
    var click_count: Int = 0
    var like_count: Int = 0
    var comment_count: Int = 0
    var favorite_count: Int = 0
    var nickname: String = ""
    var avatar: String = ""
    var position: String = ""
    var release_time: String = ""
    var format_release_time: String = ""
    var created_at: String = ""
    var is_self_posts: Int = 0 // 是否是自己的动态

    // MARK: - 高度计算相关属性

    // 实际使用的图片宽高
    var img_width_use: CGFloat = 0
    var img_height_use: CGFloat = 0

    // cell的宽高
    var img_width_cell: CGFloat = 0
    var img_height_cell: CGFloat = 0

    // 描述的高度
    var textH: CGFloat = 16.0

    var isCalHeight = false    
    var maxImageHeight: CGFloat = 280
    var minImageHeight: CGFloat = 140

    var firstImageResource: YHResourceURLs? {
        return resource_urls.first { resource in
            resource.type == 1 && !resource.url.isEmpty
        }
    }

    required init() {
    }

    func calHeightParam(_ defaultImageHeight: CGFloat = 0) {
        if isCalHeight, defaultImageHeight <= 0 {
            return
        }
        isCalHeight = true
        let text = content
        let width = (KScreenWidth - 47) / 2
        let font = UIFont.PFSC_R(ofSize: 15) // 字体大小改为15
        let maxWidth = width - 16 // 最大宽度限制（左右各8的内边距）

        // 创建NSAttributedString对象并设置属性
        let attributes = [NSAttributedString.Key.font: font] as [NSAttributedString.Key: Any]

        // 根据指定的最大宽度和字体大小计算文本的高度
        let size = (text as NSString).boundingRect(
            with: CGSize(width: maxWidth, height: .greatestFiniteMagnitude),
            options: .usesLineFragmentOrigin,
            attributes: attributes,
            context: nil
        ).size

        var textHeight: CGFloat = size.height
        // 固定2行的最大高度（行高约21，2行约42）
        if textHeight > 42.0 {
            textHeight = 42.0
        } else if textHeight < 21 {
            textHeight = 21
        }
        textH = textHeight

        // 计算图片高度
        var imageHeight: CGFloat = 0.0
        if let firstResource = firstImageResource {
            let imageSize = CGSize(width: Double(firstResource.width) ?? 0, height: Double(firstResource.height) ?? 0)

            if imageSize.width == 0 || imageSize.height == 0, defaultImageHeight <= 0 {
                imageHeight = width
            } else {
                imageHeight = defaultImageHeight > 0 ? defaultImageHeight : width * imageSize.height / imageSize.width
                if imageHeight > maxImageHeight {
                    imageHeight = maxImageHeight
                } else if imageHeight < minImageHeight {
                    imageHeight = minImageHeight
                }
            }
        } else {
            imageHeight = width
        }

        // 计算总高度
        // 图片高度 + 顶部间距10 + 头像16 + 内容间距10 + 文本高度(约40) + 底部间距10
        let totalHeight = imageHeight + 12 + 16 + 12 + textHeight + 12

        img_width_use = width
        img_height_use = imageHeight

        img_width_cell = width
        img_height_cell = totalHeight
    }
}
