//
//  YHClipperButton.swift
//  galaxy
//
//  Created by EDY on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHClipperButton: UIButton {

    var topImageView: UIImageView!
    var bottomTitleLabel: UILabel!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        topImageView = {
            let view = UIImageView()
            return view
        }()
        addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.top.centerX.equalToSuperview()
            make.width.height.equalTo(21)
        }
        
        bottomTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 11)
            label.textAlignment = .center
            label.textColor = UIColor.white
            return label
        }()
        addSubview(bottomTitleLabel)
        bottomTitleLabel.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(15)
        }
    }
    
    func setContent(_ image: String, _ title: String) {
        bottomTitleLabel.text = title
        topImageView.image = UIImage(named: image)
    }
}

class YHShareButton: UIButton {

    var topImageView: UIImageView!
    var bottomTitleLabel: UILabel!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        topImageView = {
            let view = UIImageView()
            return view
        }()
        addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.top.centerX.equalToSuperview()
            make.width.height.equalTo(48)
        }
        
        bottomTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 13)
            label.textAlignment = .center
            label.textColor = UIColor(hex: 0x666666)
            return label
        }()
        addSubview(bottomTitleLabel)
        bottomTitleLabel.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(18)
        }
    }
    
    func setContent(_ image: String, _ title: String) {
        bottomTitleLabel.text = title
        topImageView.image = UIImage(named: image)
    }
}
