//
//  ExampleBasicContentView.swift
//  ESTabBarControllerExample
//
//  Created by lihao on 2017/2/9.
//  Copyright © 2018年 Egg Swift. All rights reserved.
//

import UIKit
import ESTabBarController_swift
import Lottie

class YHBasicContentView: ESTabBarItemContentView {

    override init(frame: CGRect) {
        super.init(frame: frame)
        
        // 此渲染模式会影响图片颜色哦
        renderingMode = .alwaysOriginal

        textColor = UIColor.mainTextColor
        highlightTextColor = UIColor.mainTextColor

        titleLabel.font = UIFont.PFSC_R(ofSize: 14)
    }
    
    public required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    

}

class YHHomeLottieAnimateContentView: YHBasicContentView {

    let lottieView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "home")
        lottieView.loopMode = .playOnce
        lottieView.contentMode = .scaleAspectFit
        lottieView.isHidden = true
        return lottieView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(lottieView)
    }
    
    public required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func updateLayout() {
        super.updateLayout()
        lottieView.snp.makeConstraints { make in
            make.height.width.equalTo(25)
            make.center.equalTo(self.imageView.snp.center)
        }
    }
    
    override func selectAnimation(animated: Bool, completion: (() -> ())?) {
        super.selectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = false
        imageView.isHidden = true
        lottieView.play { completed in
            self.imageView.isHidden = false
        }
    }
    
    override func deselectAnimation(animated: Bool, completion: (() -> ())?) {
        super.deselectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = true
        imageView.isHidden = false
    }
}

class YHServiceLottieAnimateContentView: YHBasicContentView {

    let lottieView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "service")
        lottieView.loopMode = .playOnce
        lottieView.contentMode = .scaleAspectFit
        lottieView.isHidden = true
        return lottieView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(lottieView)
    }
    
    public required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func updateLayout() {
        super.updateLayout()
        lottieView.snp.makeConstraints { make in
            make.height.width.equalTo(25)
            make.center.equalTo(self.imageView.snp.center)
        }
    }
    
    override func selectAnimation(animated: Bool, completion: (() -> ())?) {
        super.selectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = false
        imageView.isHidden = true
        lottieView.play { completed in
            self.imageView.isHidden = false
        }
    }
    
    override func deselectAnimation(animated: Bool, completion: (() -> ())?) {
        super.deselectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = true
        imageView.isHidden = false
    }
}

class YHCommunityLottieAnimateContentView: YHBasicContentView {

    let lottieView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "community")
        lottieView.loopMode = .playOnce
        lottieView.contentMode = .scaleAspectFit
        lottieView.isHidden = true
        return lottieView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(lottieView)
    }
    
    public required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func updateLayout() {
        super.updateLayout()
        lottieView.snp.makeConstraints { make in
            make.height.width.equalTo(25)
            make.center.equalTo(self.imageView.snp.center)
        }
    }
    
    override func selectAnimation(animated: Bool, completion: (() -> ())?) {
        super.selectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = false
        imageView.isHidden = true
        lottieView.play { completed in
            self.imageView.isHidden = false
        }
    }
    
    override func deselectAnimation(animated: Bool, completion: (() -> ())?) {
        super.deselectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = true
        imageView.isHidden = false
    }

}

class YHMyLottieAnimateContentView: YHBasicContentView {

    let lottieView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "my")
        lottieView.loopMode = .playOnce
        lottieView.contentMode = .scaleAspectFit
        lottieView.isHidden = true
        return lottieView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(lottieView)
    }
    
    public required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func updateLayout() {
        super.updateLayout()
        lottieView.snp.makeConstraints { make in
            make.height.width.equalTo(25)
            make.center.equalTo(self.imageView.snp.center)
        }
    }
    
    override func selectAnimation(animated: Bool, completion: (() -> ())?) {
        super.selectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = false
        imageView.isHidden = true
        lottieView.play { completed in
            self.imageView.isHidden = false
        }
    }
    
    override func deselectAnimation(animated: Bool, completion: (() -> ())?) {
        super.deselectAnimation(animated: animated, completion: nil)
        lottieView.isHidden = true
        imageView.isHidden = false
    }
}
