//
//  YHShareViewOnTablebarView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/7/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 导航栏上的 分享、咨询 按钮
 */



//tabbar上view 的参数对象
struct TabBarShareModel {
    var showFlag : Bool = false //是否展示tabbar上的分享view
    var shareTitle: String = "" // 分享到小程序的标题
    var shareUrl : String = "" //分享到小程序上的url
    var codeUrl : String = "" //用于展示的二维码图片
    var downloadUrl : String = ""//用于下载的二维码图片
}


class YHShareViewOnTablebarView: UIView {
    static let viewH : CGFloat = 98.0
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    
    typealias Block = (Int) -> () //0-快速测评 1-资讯顾问 2-分享有礼
    var block: Block?
    
    
    lazy var topLine: UIView = {
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        return line
    }()
    
    
    //分享按钮
    lazy var shareBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 11)
//        button.contentHorizontalAlignment = .center
        button.setTitle("分享", for: .normal)
        button.setTitle("分享", for: .highlighted)
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.setTitleColor(UIColor.mainTextColor, for: .highlighted)
        button.setImage(UIImage(named: "share_item"), for: .normal)
        button.setImage(UIImage(named: "share_item"), for: .highlighted)
        
        button.addTarget(self, action: #selector(clickShareBtn), for: .touchUpInside)
        return button
    }()
    
    //预约咨询
    lazy var consultantBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("预约咨询", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickConsultantBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.brandMainColor
        return button
    }()
    
    
   
    
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
//        if YHLoginManager.shared.isLogin() {
//            quickEvaluationBtn.isHidden = true
//            consultantBtn.isHidden = true
//            rewardBtn.isHidden = false
//        } else {
//            quickEvaluationBtn.isHidden = false
//            consultantBtn.isHidden = false
//            rewardBtn.isHidden = true
//        }
        
        
        shareBtn.iconInTop(spacing: 0)
    }
}

private extension YHShareViewOnTablebarView {
    func setupUI() {
        backgroundColor = .white
        
        addSubview(topLine)
        addSubview(shareBtn)
        addSubview(consultantBtn)
        
        
        topLine.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        shareBtn.snp.makeConstraints { make in
            make.centerY.equalTo(consultantBtn).offset(4.0)
            make.left.equalTo(14)
            make.right.equalTo(consultantBtn.snp.left).offset(-14)
            make.height.equalTo(40)
            make.width.equalTo(60)
        }
        
        
        consultantBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalTo(shareBtn.snp.right).offset(14)
            make.right.equalTo(-20)
            make.height.equalTo(44)
        }
        
    }
    
    
    @objc func clickShareBtn() {
        block?(0)
    }
    
    @objc func clickConsultantBtn() {
        block?(1)
    }
}
