//
//  YHMyFriendsNoDataView.swift
//  galaxy
//
//  Created by edy on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFriendsNoDataView: UIView {

    var bottomBtnClick:(()->())?
    lazy var bgImgView:UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_no_friend_bg"))
        return view
    }()
    
    lazy var titleLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize:14)
        label.text = "暂无好友"
        return label
    }()
    
    lazy var bottomBtn:UIButton = {
       let btn = UIButton()
        btn.setTitle("返回人脉主页", for: .normal)
        btn.backgroundColor = .brandMainColor
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 13)
        btn.layer.cornerRadius = 3
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    @objc func didBottomBtnClicked() {
        self.bottomBtnClick?()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.backgroundColor = .white
        self.addSubview(self.bgImgView)
        self.addSubview(self.titleLabel)
        self.addSubview(self.bottomBtn)
        
        self.bgImgView.snp.makeConstraints { make in
            make.width.equalTo(128)
            make.height.equalTo(128)
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(148)
        }
        
        self.titleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.bgImgView.snp.bottom).offset(12)
            make.height.equalTo(20)
            make.centerX.equalToSuperview()
        }
        self.bottomBtn.snp.makeConstraints { make in
            make.width.equalTo(110)
            make.height.equalTo(38)
            make.centerX.equalToSuperview()
            make.top.equalTo(self.titleLabel.snp.bottom).offset(22)
        }
    }
}
