//
//  YHPeopleMatchNoDataView.swift
//  galaxy
//
//  Created by edy on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPeopleMatchNoDataView: UIView {

    static let height = 198.0
    
    var relookBlock:(()->())?
    
    lazy var bgImgView:UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_match_no_data_bg"))
        return view
    }()
    
    lazy var titleLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.white
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize:14)
        label.text = "本轮智能匹配人脉已到底~"
        return label
    }()
    
    lazy var relookBtn:UIButton = {
       let btn = UIButton()
        btn.setTitle("重新查看", for: .normal)
        btn.backgroundColor = .clear
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 13)
        btn.layer.cornerRadius = 3
        btn.layer.borderWidth = 1.0
        btn.layer.borderColor = UIColor.white.cgColor
        btn.addTarget(self, action: #selector(didRelookBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    
    @objc func didRelookBtnClicked() {
        self.isHidden = true
        self.relookBlock?()
    }
    
    static func createView() -> YHPeopleMatchNoDataView {
        let view = YHPeopleMatchNoDataView(frame: CGRectMake(0, 0, KScreenWidth, Self.height))
        return view
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(self.bgImgView)
        self.addSubview(self.titleLabel)
        self.addSubview(self.relookBtn)
        
        self.bgImgView.snp.makeConstraints { make in
            make.width.equalTo(177)
            make.height.equalTo(88)
            make.centerX.equalToSuperview()
            make.top.equalToSuperview()
        }
        
        self.titleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.bgImgView.snp.bottom).offset(30)
            make.height.equalTo(20)
            make.centerX.equalToSuperview()
        }
        self.relookBtn.snp.makeConstraints { make in
            make.width.equalTo(110)
            make.height.equalTo(38)
            make.centerX.equalToSuperview()
            make.top.equalTo(self.titleLabel.snp.bottom).offset(22)
        }
    }
}
