//
//  YHHomeInfoDetailViewController.swift
//  galaxy
//
//  Created by edy on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHHomeInfoDetailViewController: YHBaseViewController {

    var isHot:Bool = false // 是否是精品
    var classifyId:Int = 0
    var isShowTab: Bool = true
    lazy var viewModel : YHHomePageViewModel = {
        let viewModel = YHHomePageViewModel()
        return viewModel
    }()
    
    lazy var collectView = {
        // 设置布局方向
        let flowLayout = YHHomeCollectionLayout()
        flowLayout.minimumInteritemSpacing = 7.0
        flowLayout.minimumColumnSpacing = 7.0
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .white
        collectinoView.register(YHHomeCollectionViewCell.self, forCellWithReuseIdentifier:YHHomeCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.contentInset = UIEdgeInsets(top: 16.0, left: 0.0, bottom: 0.0, right: 0.0)
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.showsVerticalScrollIndicator = false
        collectinoView.es.addYHPullToRefresh {
            self.getTheNewestInfoList(isFirstPage: true)
        }
        collectinoView.es.addInfiniteScrolling {
            self.getTheNewestInfoList(isFirstPage: false)
        }
        return collectinoView
    }()
    
    lazy var emptyDataTipsView: YHEmptyDataView = {
        let view = YHEmptyDataView.createView("暂无内容", kEmptyCommonBgName)
        let topMargin = 310-k_Height_NavigationtBarAndStatuBar
        view.topMargin = topMargin
        view.isHidden = true
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.setupUI()
        self.getTheNewestInfoList(isFirstPage:true)
    }
    
    func setupUI() {
        gk_navigationBar.isHidden = true
        self.view.backgroundColor = .white
        self.view.addSubview(self.collectView)
        self.view.addSubview(self.emptyDataTipsView)
        self.collectView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(20)
            make.right.equalTo(-20)
        }
        self.emptyDataTipsView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}

// MARK: - UICollectionViewDelegate, UICollectionViewDataSource
extension YHHomeInfoDetailViewController: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        // 最新资讯
        return self.viewModel.arrHomeNewsData?.count ?? 0
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHHomeCollectionViewCell.cellReuseIdentifier, for: indexPath) as! YHHomeCollectionViewCell
        cell.listModel = self.viewModel.arrHomeNewsData?[indexPath.row]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        guard let model = self.viewModel.arrHomeNewsData?[indexPath.row] else { return }
        if model.type == 2 {
            let vc = YHHomeWebViewController()
            vc.url = YHBaseUrlManager.shared.curH5URL() + "articleDetail.html" + "?id=\(model.id)"
            vc.id = model.id
            vc.block = { item in
                if let arr = self.viewModel.arrHomeNewsData {
                    for (index,targetItem) in arr.enumerated() {
                        if targetItem.id == item.id {
                            targetItem.is_like = item.is_like
                            targetItem.like_count = item.like_count
                            self.collectView.reloadItems(at: [IndexPath.SubSequence(item: index, section: 0)])
                        }
                    }
                }
            }
            self.navigationController?.pushViewController(vc)
        } else if model.type == 1 {
            printLog("直接播放视频")
        }
    }
}

//MARK: - CollectionViewWaterfallLayoutDelegate
extension YHHomeInfoDetailViewController : CollectionViewWaterfallLayoutDelegate {
    func collectionView(_ collectionView: UICollectionView, layout: UICollectionViewLayout, sizeForItemAtIndexPath indexPath: NSIndexPath) -> CGSize {
        
        let count = self.viewModel.arrHomeNewsData?.count ?? 0
        if indexPath.row < count {
            guard let model = self.viewModel.arrHomeNewsData?[indexPath.row] else { return CGSize.zero }
            return CGSize(width: model.img_width_cell, height: model.img_height_cell)
        }
        
        let width = (KScreenWidth - 47) / 2
        return CGSize(width: width, height: 140.0)
    }
}

extension YHHomeInfoDetailViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}

extension YHHomeInfoDetailViewController {
    // 获取最新资讯
    func getTheNewestInfoList(isFirstPage: Bool) {
        let haveHot = self.isHot ? self.isHot : nil
        self.viewModel.getList(isFirsPage: isFirstPage, isHot: haveHot, classifyId: classifyId) { success, error in
            self.collectView.reloadData()
            self.collectView.es.stopPullToRefresh()
            self.collectView.es.stopLoadingMore()
            if self.viewModel.hasMoreForHomeNews == false {
                self.collectView.es.noticeNoMoreData()
                self.collectView.footer?.alpha = 1
            }
            let count = self.viewModel.arrHomeNewsData?.count ?? 0
            self.emptyDataTipsView.isHidden = (count > 0)
            self.collectView.isHidden = (count <= 0)
        }
    }
}

