//
//  YHInvitationWithGiftsDetailView.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationWithGiftsDetailView: UIView {
    var centerView: UIView!
    var topView: UIView!
    var topContentView: UIView!
    var topImageView: UIImageView!
    var bgImageView: UIImageView!
    var scrollView: UIScrollView!
    var titleLabel: UILabel!
    var titleImage: UIImageView!
    var closeButton: UIButton!
    var messageLabel: UILabel!
    var messageImage: UIImageView!
    var bgView: UIImageView!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
//        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
//        tap.delegate = self
//        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .clear
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.height.equalTo(562)
            make.width.equalTo(311)
        }
        
        topView = {
            let view = UIView()
            view.backgroundColor = .clear
            return view
        }()
        centerView.addSubview(topView)
        topView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(518)
        }
        
        topContentView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        topView.addSubview(topContentView)
        topContentView.snp.makeConstraints { make in
            make.top.equalTo(6)
            make.left.right.bottom.equalToSuperview()
        }
        
        bgView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "invitation_with_gifts_detail_bg")
            imageView.isUserInteractionEnabled = true
            return imageView
        }()
        topContentView.addSubview(bgView)
        bgView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-12)
            make.left.equalTo(12)
            make.top.equalTo(12)
        }
        
        topImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "invitation_with_gifts_detail_top")
            return imageView
        }()
        topView.addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.width.equalTo(157)
            make.centerX.equalToSuperview()
            make.height.equalTo(37)
            make.top.equalToSuperview()
        }
        
        scrollView = {
            let view = UIScrollView()
            view.bounds = CGRect(x: 0, y: 0, width: 287, height: 1223)
            // 去除弹簧效果
            view.bounces = false
            
            // 去除滑动指示器
            view.showsHorizontalScrollIndicator = false
            view.showsVerticalScrollIndicator = false

            return view
        }()
        topContentView.addSubview(scrollView)
        scrollView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-12)
            make.left.equalTo(12)
            make.top.equalTo(41)
        }
        
        bgImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "invitation_with_gifts_detail_bg")
            imageView.isHidden = true
            return imageView
        }()
        scrollView.addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.right.bottom.left.top.equalToSuperview()
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "规则说明"
            label.font = UIFont.PFSC_M(ofSize: 15)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        scrollView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.height.equalTo(21)
            make.top.equalTo(9)
        }
        
        titleImage = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "invitation_with_gifts_detail_title")
            return imageView
        }()
        scrollView.addSubview(titleImage)
        titleImage.snp.makeConstraints { make in
            make.width.equalTo(259)
            make.centerX.equalToSuperview()
            make.height.equalTo(681)
            make.top.equalTo(42)
        }
        
        messageLabel = {
            let label = UILabel()
            label.text = "积分入账及提现"
            label.font = UIFont.PFSC_M(ofSize: 15)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        scrollView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.height.equalTo(21)
            make.top.equalTo(753)
        }
        
        messageImage = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "invitation_with_gifts_detail_message")
            return imageView
        }()
        scrollView.addSubview(messageImage)
        messageImage.snp.makeConstraints { make in
            make.width.equalTo(259)
            make.centerX.equalToSuperview()
            make.height.equalTo(426)
            make.top.equalTo(785)
        }
        
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "invitation_with_gifts_detail_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.height.equalTo(24)
            make.bottom.equalToSuperview()
        }
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
}

extension YHInvitationWithGiftsDetailView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

