//
//  YHInvitationWithGiftsHeadView.swift
//  galaxy
//
//  Created by EDY on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationWithGiftsHeadView: UIView {
    var centerImageView: UIImageView!
    var bottomImageView: UIImageView!
    var bgView: UIView!
    var marqueeLabel: UILabel!
    var subMarqueeLabel: UILabel!
    var timer: Timer?
    var currentOffset: CGFloat = 0
    
    var dataSource: [YHShareCashOutModel]? {
        didSet {
            guard let dataSource = dataSource else { return }
            if dataSource.count == 0 {
                bgView.isHidden = true
            } else {
                bgView.isHidden = false
                var index = 0
                var nextIndex = 1
                if dataSource.count == 1 {
                    nextIndex = 0
                }
                let model = dataSource.first ?? YHShareCashOutModel()
                let nextModel = dataSource[nextIndex]
                marqueeLabel.text = "\(model.mobile) 已提现 \(model.amount) 元"
                subMarqueeLabel.text = "\(nextModel.mobile) 已提现 \(nextModel.amount) 元"

                timer = Timer.scheduledTimer(withTimeInterval: 2.0, repeats: true) { [weak self] _ in
                    index = index + 1
                    UIView.animate(withDuration: 0.5) {
                        self?.marqueeLabel.frame.origin.y = -30
                        self?.subMarqueeLabel.frame.origin.y = 0
                    } completion: { flag in
                        let resultIndex = index % dataSource.count
                        let nextIndex = (index + 1) % dataSource.count
                        let resultModel = dataSource[resultIndex]
                        let nextModel = dataSource[nextIndex]

                        self?.marqueeLabel.text = "\(resultModel.mobile) 已提现 \(resultModel.amount) 元"
                        self?.subMarqueeLabel.text = "\(nextModel.mobile) 已提现 \(nextModel.amount) 元"

                        self?.marqueeLabel.frame.origin.y = 0
                        self?.subMarqueeLabel.frame.origin.y = 30
                    }
                }
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        self.backgroundColor = UIColor(hex: 0xebf4fe)
        let height = KScreenWidth / 0.735
        centerImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "invitation_with_gifts_head")
            return view
        }()
        addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(height)
        }
        
        let bottomHeight = (KScreenWidth - 24) / 1.34
        bottomImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "invitation_with_gifts_head_bottom")
            return view
        }()
        addSubview(bottomImageView)
        bottomImageView.snp.makeConstraints { make in
            make.height.equalTo(bottomHeight)
            make.left.equalTo(12)
            make.right.equalTo(-12)
            make.bottom.equalTo(-8)
        }
        
        bgView = {
            let view = UIView()
            view.backgroundColor = .white.withAlphaComponent(0.68)
            view.clipsToBounds = true
            view.layer.masksToBounds = true
            view.layer.cornerRadius = 15
            view.layer.borderWidth = 1
            view.layer.borderColor = UIColor.white.cgColor
            view.isHidden = true
            return view
        }()
        addSubview(bgView)
        bgView.snp.makeConstraints { make in
            make.height.equalTo(30)
            make.width.equalTo(209)
            make.centerX.equalToSuperview()
            make.top.equalTo(0.87 * KScreenWidth)
        }
        
        marqueeLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = .black
            label.textAlignment = .center
            return label
        }()
        bgView.addSubview(marqueeLabel)
        marqueeLabel.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
        
        subMarqueeLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = .black
            label.textAlignment = .center
            return label
        }()
        bgView.addSubview(subMarqueeLabel)
        subMarqueeLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(bgView.snp.bottom)
            make.height.equalTo(30)
        }
    }
    
    deinit {
        timer?.invalidate()
    }
    
    func updateAllViews() {
        
    }
    
}
