//
//  YHInvitationWithGiftsShareBottomView.swift
//  galaxy
//
//  Created by EDY on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationWithGiftsShareBottomView: UIView {
    static let viewH : CGFloat = 98.0
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    typealias Block = (Int) -> ()
    var block: Block?
    var saveButton: UIButton!
}

private extension YHInvitationWithGiftsShareBottomView {
    func setupUI() {
        saveButton = {
            let button = UIButton(type: .custom)
            button.adjustsImageWhenHighlighted = false
            button.setBackgroundImage(UIImage(named: "invitation_with_gifts_share"), for: .normal)
            button.setTitle("立即分享", for: .normal)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 18)
            button.setTitleColor(UIColor.white, for: .normal)
            button.addTarget(self, action: #selector(save), for: .touchUpInside)
            return button
        }()
        addSubview(saveButton)
        saveButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(58)
            make.top.equalTo(5)
        }
    }
    
    @objc func save() {
        block?(0)
    }
}
