//
//  YHShareStepView.swift
//  galaxy
//
//  Created by EDY on 2024/8/2.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHShareStepView: UIView {
    var stepOneView: UIView!
    var stepTwoView: UIView!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        stepOneView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0x94a3b8)
            return view
        }()
        addSubview(stepOneView)
        stepOneView.snp.makeConstraints { make in
            make.top.left.bottom.equalToSuperview()
            make.width.equalTo(16)
        }
        
        stepTwoView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0x94a3b8).withAlphaComponent(0.3)
            return view
        }()
        addSubview(stepTwoView)
        stepTwoView.snp.makeConstraints { make in
            make.top.right.bottom.equalToSuperview()
            make.width.equalTo(16)
        }
    }
    
}
