//
//  YHEvaluationView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHEvaluationView: UIView {

    static let viewH = 82.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bkgImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "evaluation_bkg")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    
    lazy var lable1: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "香港身份20秒测评"
        lable.font = UIFont.PFSC_B(ofSize: 17)
        lable.textColor = UIColor.mainTextColor
        return lable
    }()
    
    
    lazy var iconImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "evaluation_icon")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    
    lazy var buttonImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "evaluation_button")
        imgV.clipsToBounds = true
        imgV.layer.cornerRadius = kCornerRadius3
        return imgV
    }()
}

extension YHEvaluationView {
    
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        //跳转测评页
        let vc = YHH5WebViewVC()
        vc.url = YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/evaluation?channel=APP-zrll"
        vc.isShowRightShareItemFlag = true
        parentViewController?.navigationController?.pushViewController(vc)
    }
    
    func setupUI() {
        addSubview(bkgImageV)
        addSubview(iconImageV)
        addSubview(lable1)
        addSubview(buttonImageV)
        
        
        bkgImageV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        iconImageV.snp.makeConstraints { make in
            make.width.height.equalTo(34)
            make.left.equalTo(24)
            make.centerY.equalToSuperview()
        }
        
        lable1.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(iconImageV.snp.right).offset(12)
            make.right.equalTo(buttonImageV.snp.left).offset(-24)
            make.height.equalTo(22)
        }
        
        buttonImageV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-24)
            make.height.equalTo(34)
            make.width.equalTo(76)
        }
        
        let aa: ASAttributedString = .init("香港身份", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("20秒", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.brandMainColor))
        let cc: ASAttributedString = .init("测评", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.mainTextColor))
        lable1.attributed.text = aa + bb + cc
    }
}
