//
//  YHHkLifeAndIdItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum HkLifeItemType : Int {
    case unknow = -1 //未知
    case hkID = 0    //香港身份
    case hklife = 1  //香港生活
}

class YHHkLifeAndIdItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    lazy var bkgImagV: UIImageView = {
        let imageV = UIImageView()
        imageV.contentMode = .scaleAspectFill
        return imageV
    }()
    
    lazy var iconV: UIImageView = {
        let imageV = UIImageView()
        imageV.contentMode = .scaleAspectFill
        return imageV
    }()
    
    lazy var titleLable : UILabel = {
        let label = UILabel()
        label.text = "香港身份"
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.lineBreakMode = .byTruncatingMiddle
        return label
    }()
    
    
    lazy var subtitleLable:UILabel = {
        let label = UILabel()
        label.text = "去香港"
        label.textColor = UIColor.yhGreyColor
        label.font = UIFont.PFSC_R(ofSize: 11)
        label.lineBreakMode = .byTruncatingMiddle
        return label
    }()
    
    
    var itemType : HkLifeItemType = .unknow {
        didSet {
            updateUI()
        }
    }
}

private extension YHHkLifeAndIdItemView {
    func initView() {
        addSubview(bkgImagV)
        bkgImagV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        addSubview(iconV)
        iconV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(kMargin)
            make.width.height.equalTo(34)
        }
        
        
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalTo(iconV.snp.top).offset(-3)
            make.left.equalTo(iconV.snp.right).offset(kMargin)
            make.height.equalTo(24)
            make.right.equalTo(-10)
        }
        
        
        addSubview(subtitleLable)
        subtitleLable.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(2)
            make.left.equalTo(titleLable.snp.left)
            make.height.equalTo(16)
            make.right.equalTo(titleLable.snp.right)
        }
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(tapView(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    
    func updateUI() {
        if itemType == .hkID {
            bkgImagV.image = UIImage(named: "hklife_bkg_0")
            iconV.image = UIImage(named: "hklife_icon_0")
            titleLable.text = "香港身份"
            subtitleLable.text = "去香港"
        } else if itemType == .hklife {
            bkgImagV.image = UIImage(named: "hklife_bkg_1")
            iconV.image = UIImage(named: "hklife_icon_1")
            titleLable.text = "香港生活"
            subtitleLable.text = "在香港"
        } else {
            printLog("errorr:未处理")
        }
    }
    
    
    @objc func tapView(gestureRecognizer:UITapGestureRecognizer) {
        if itemType == .hkID {
          //香港身份
            let vc = YHHKCenterViewController()
            vc.defaltIndex = 0
            UIViewController.current?.navigationController?.pushViewController(vc)
        } else if itemType == .hklife {
          //香港生活
            let vc = YHHKCenterViewController()
            vc.defaltIndex = 1
            UIViewController.current?.navigationController?.pushViewController(vc)
        } else {
            printLog("errorr:未处理")
        }
    }
}
