//
//  YHHomeKingKongBlockItem.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeKingKongBlockItem: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var iconV: UIImageView = {
        let imageV = UIImageView()
        imageV.contentMode = .scaleAspectFill
        return imageV
    }()
    
    lazy var subtitleLable:UILabel = {
        let label = UILabel()
        label.text = "去香港"
        label.textColor = UIColor.yhGreyColor
        label.font = UIFont.PFSC_M(ofSize: 12)
        label.lineBreakMode = .byTruncatingMiddle
        label.textAlignment = .center
        return label
    }()
    
    var dataModel : YHHomeKingKongBlockModel? {
        didSet {
            updateUI()
        }
    }
    
    let radio : CGFloat = YHHomeKingKongBlockView.viewH / 76.0
    
    
    lazy var bkgImgV: UIImageView = {
        let imageV = UIImageView()
        imageV.contentMode = .scaleAspectFill
        imageV.clipsToBounds = true
        return imageV
    }()
}

private extension YHHomeKingKongBlockItem {
    func initView() {
        backgroundColor = UIColor(hex: 0xF8FAFB, alpha: 1.0)
        
//        addSubview(iconV)
//        iconV.snp.makeConstraints { make in
//            make.centerX.equalToSuperview()
//            make.width.height.equalTo(31)
//            make.top.equalTo(10 * radio)
//        }
//        
//        addSubview(subtitleLable)
//        subtitleLable.snp.makeConstraints { make in
//            make.centerX.equalToSuperview()
//            make.left.equalTo(4)
//            make.right.equalTo(-4)
//            make.height.equalTo(17)
//            make.bottom.equalTo(-8 * radio)
//        }
        
        
        addSubview(bkgImgV)
        bkgImgV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
    
    func updateUI() {
        guard let dataModel = dataModel else { return }
//        iconV.image = UIImage(named: dataModel.iconName)
//        subtitleLable.text = dataModel.title
        
        bkgImgV.image = UIImage(named: dataModel.iconName)
    }
}
