//
//  YHHomeSalonAreaView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeSalonAreaView: UIView {

    static let viewH = 259.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bkgImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_salon_bkg")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    
    lazy var lable1: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "银河线下沙龙"
        lable.font = UIFont.PFSC_B(ofSize: 17)
        lable.textColor = UIColor.black
        return lable
    }()
    
    
    lazy var lable2: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "线上预约，线下参加"
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textColor = UIColor.yhGreyColor
        return lable
    }()
    
    
    lazy var lable3: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "前往预约"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .center
        lable.layer.borderColor = UIColor.mainTextColor18.cgColor
        lable.layer.borderWidth = 1
        lable.clipsToBounds = true
        lable.layer.cornerRadius = kCornerRadius3
        return lable
    }()
}

extension YHHomeSalonAreaView {
    
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        goTabBarBy(tabType: .community)
        DispatchQueue.main.async {
            NotificationCenter.default.post(name: YhConstant.YhNotification.goActivityVCNotifiction, object: nil)
        }
    }
    
    func setupUI() {
        backgroundColor = UIColor(hex: 0xF8FAFB)
        
        addSubview(bkgImageV)
        bkgImageV.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(166)
        }
        
        let subView : UIView = UIView()
        addSubview(subView)
        subView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalTo(bkgImageV.snp.bottom)
        }
        
        
        subView.addSubview(lable1)
        lable1.snp.makeConstraints { make in
            make.top.left.equalTo(24)
            make.height.equalTo(24)
        }
        
        
        
        subView.addSubview(lable2)
        lable2.snp.makeConstraints { make in
            make.top.equalTo(lable1.snp.bottom).offset(4)
            make.left.equalTo(lable1.snp.left)
            make.height.equalTo(17)
        }
        
        
        subView.addSubview(lable3)
        lable3.snp.makeConstraints { make in
            make.right.equalTo(-24)
            make.centerY.equalToSuperview()
            make.width.equalTo(76)
            make.height.equalTo(34)
        }
    }
}
