//
//  YHPrincleViewModel.swift
//  galaxy
//
//  Created by edy on 2024/4/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHPrincleViewModel: YHBaseViewModel {
    
    var waitResultModel = YHPrincipleWaitResultModel()
    var envelopModel = YHPrincipleEnvelopeModel()
    var uploadDetailModel = YHPrincipleUploadDetailModel()
    
    
    //原则批、正式批弹窗状态
    var alertStatusModel : YHPrincipleAlertStatusModel?
    
    //正式批 操作指引是否确认
    var isOfficialGuildCheckFlag : Bool = false
    
}


extension YHPrincleViewModel {
    
    //获取获批信列表
    func getApprovalLetter(param:[String : Any],callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        let param = ["IdentifyGetHKAcceptOperateGuid":2]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getApprovalLetterApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
//                guard let resultModel = YHPrincipleAlertStatusModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
//                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
//                    callback?(false, err)
//                    return
//                }
//                self.alertStatusModel = resultModel
//                callback?(true, nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    
    //上报弹窗状态
    func postAlertStatus(_ type : Int, callback:((_ success: Bool, _ error:YHErrorModel?)->())?) {
        
        var params: [String : Any] = [:]
        if type == 14 {
            //IdentifyPrincipleApprovalCongratulation      = 14 // 原则批获批祝贺弹窗
            params = ["IdentifyPrincipleApprovalCongratulation":14]
        } else if type == 6 {
            //IdentifyApprovalCongratulation               = 6  // 赴港获批祝贺弹窗 - 正式批
            params = ["IdentifyApprovalCongratulation":6]
            
        } else if type == 2 {
            //IdentifyGetHKAcceptOperateGuid               = 2  // 香港身份获批操作指引
            params = ["IdentifyGetHKAcceptOperateGuid":2]
        } else {
            return
        }
            
        
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.postAlertStatusApi

        let _ = YHNetRequest.postRequest(url: strUrl, params: params) {
            json, code in
            //1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                callback?(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    
    //获取正式批 操作指引 确认状态
    func getOfficialCheckStatus(callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        let param = ["IdentifyGetHKAcceptOperateGuid":2]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getOfficialCheckStatusApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                if let flag = json.data as? Bool {
                    self.isOfficialGuildCheckFlag = flag
                } else {
                    self.isOfficialGuildCheckFlag = false
                }
                callback?(true, nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    //获取是否弹窗 原则批、正式批
    func getPrincleStatus(callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getAlertStatusApi
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleAlertStatusModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.alertStatusModel = resultModel
                callback?(true, nil)
                
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    
    func getPrincipleWaitReviewResult(params:[String : Any], callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getProfileList
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleWaitResultModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.waitResultModel = resultModel
                callback?(true, nil)
                
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    func getEnvelopeInfo(orderId:Int, callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getReviewResult
        
        let params: [String : Any] = ["order_id": orderId]
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleEnvelopeModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.envelopModel = resultModel
//                self.envelopModel = self.getEnvelopModel()
                callback?(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
//                self.envelopModel = self.getEnvelopModel()
                callback?(false, err)
            }
            
        } failBlock: { err in
//            self.envelopModel = self.getEnvelopModel()
            callback?(false, err)
        }
    }
    
    func getPrincipleUploadDetail(orderId:Int, callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getUploadDetail
        
        let params: [String : Any] = ["order_id": orderId]
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleUploadDetailModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.uploadDetailModel = resultModel
                callback?(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    func requestIsSendMail(orderId:Int, callback:((_ isSend: Bool)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getIsSendMail
        let params: [String : Any] = ["order_id": orderId]
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { json, code in
            //1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                if let isSend = json.data as? Bool {
                    callback?(isSend)
                } else {
                    callback?(false)
                }
                
            } else {
                callback?(false)
            }
            
        } failBlock: { err in
            callback?(false)
        }
    }
    
    func uploadPrincipleFiles(_ files: [YHPrincipleRequestModel], callback:((_ success: Bool, _ error:YHErrorModel?)->())?) {
        
        guard let arr = files.toArray() else { return }
        let params: [String : Any] = ["file_list" : arr]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.uploadFiles

        let _ = YHNetRequest.postRequest(url: strUrl, params: params) {
            json, code in
            //1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                callback?(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    func uploadImageArr(_ targetImgArr:[YHSelectImageItem], successBlock:(([YHPrincipleContentUrlModel])->())?)  {
        
        let ossGroup = DispatchGroup()
        var ossArr:[YHPrincipleContentUrlModel] = []

        YHHUD.show(.progress(message: "上传中..."))
        // 先将所有图片组上传到OSS
        for item in targetImgArr {
            if let image = item.data {
                ossGroup.enter()
                self.uploadImage(image, imageName:item.name) {
                    success, urlModel in
                    if success, let model = urlModel {
                        ossArr.append(model)
                    }
                    ossGroup.leave()
                }
            }
        }
        
        // 再将OSS上传信息组上传到服务器
        ossGroup.notify(queue: .main) {
            YHHUD.hide()
            if ossArr.count <= 0 {
                YHHUD.flash(message: "上传失败")
                successBlock?([])
                return
            }
            successBlock?(ossArr)
        }
     }
    
    func uploadImage(_ img: UIImage, imageName:String, callBack:((Bool, YHPrincipleContentUrlModel?)->())?)  {
        
        // 先OSS上传得到URL
        self.uploadImage(img) {
            url, error in
            if let url = url, !url.isEmpty {
                var suffix = "jpg"
                let suffixName = url.pathExtension.lowercased()
                if !suffixName.isEmpty {
                    suffix = suffixName
                }
                
                // 再调用业务接口
                let model = YHPrincipleContentUrlModel()
                model.name = imageName
                model.url = url
                model.fileUrl = url
                
                let dateFormatter = DateFormatter()
                dateFormatter.dateFormat = "HH:mm:ss"
                let dateString = dateFormatter.string(from: Date())
                model.updated_at = dateString
                
                callBack?(true, model)
                
            } else {
                callBack?(false, nil)
            }
        }
    }
    
//    func getEnvelopModel() -> YHPrincipleEnvelopeModel {
//        let model = YHPrincipleEnvelopeModel()
//        model.name = "黄金龙"
//        model.sex = 1
//        model.date = "2024-12-12"
//        return model
//    }
//
//    func getTestModel() -> YHPrincipleWaitResultModel {
//
//        var files: [YHFileNumberList] = []
//        let m = YHFileNumberList()
//        m.applicationName = "杜宇"
//        m.fileNumber = "23412-AVAVS-SADFAS"
//        let m2 = YHFileNumberList()
//        m2.applicationName = "宇"
//        m2.fileNumber = "23412-AVAVS-SADFAS"
//        files.append(m)
//        files.append(m2)
//
//        var imgs: [YHResultImageList] = []
//        let n = YHResultImageList()
//        n.applicationName = "嘟嘟"
//        let n1 = YHResultImageList()
//        n1.applicationName = "嘟嘟"
//        let n2 = YHResultImageList()
//        n2.applicationName = "嘟嘟"
//        imgs.append(n)
//        imgs.append(n1)
//        imgs.append(n2)
//
//        let applicant = YHApplicant()
//        applicant.userName = "哈哈哈"
//
//        let model = YHPrincipleWaitResultModel(lastQueryAt: "2024-12-01 23:34:12",
//                                               queryCount: 40,
//                                               fileNumberList: files,
//                                               resultImageList: imgs,
//                                               applicant: applicant,
//                                               applicationFileNumberAttachment: "你要死啊")
//        return model
//    }
//
    
    
}
