//
//  YHFileListItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFileListItemView: UIView {
    
    var clickBlock:((YHSupplementInfo?)->())?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    //index
    private lazy var indexLable : UILabel = {
        let lable0 = UILabel(text: "index")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_B(ofSize: 19)
        lable0.textAlignment = .center
        return lable0
    }()
    
    //title
    private lazy var titleLable : UILabel = {
        let lable0 = UILabel(text: "title")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_R(ofSize: 15)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        return lable0
    }()
    
    //subtitle
    private lazy var subtitleLable : UILabel = {
        let lable0 = UILabel(text: "subtitle")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 12)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        return lable0
    }()
    
    //status
    private lazy var statusLable : UILabel = {
        let lable0 = UILabel(text: "待提交")
        lable0.textColor = UIColor.brandMainColor
        lable0.font = UIFont.PFSC_M(ofSize: 12)
        lable0.lineBreakMode = .byWordWrapping
        lable0.textAlignment = .right
        return lable0
    }()
    
    private lazy var nextImageView : UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.image = UIImage(named: "file_list_right_arrow_blue")
        return view
    }()
    
    private lazy var statusHoldView : UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    
    //line
    private lazy var line : UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    
   
    
    
    
    
    
    
    var dataModel : YHSupplementInfo? {
        didSet {
            updateUI()
        }
    }
    
    var myIndex : Int  = -1 {
        didSet {
            updateIndex()
        }
    }
}

private extension YHFileListItemView {
    func initView() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didItemViewClicked))
        self.addGestureRecognizer(tap)
        
        addSubview(indexLable)
        indexLable.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.width.equalTo(26)
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
//        addSubview(statusLable)
//        statusLable.snp.makeConstraints { make in
//            make.right.equalTo(-26)
//            make.centerY.equalToSuperview()
//            make.height.equalTo(20)
//            make.width.equalTo(60)
//        }
        
        addSubview(statusHoldView)
        statusHoldView.snp.makeConstraints { make in
            make.right.equalTo(-26)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(60 + 16)
        }
        
        statusHoldView.addSubview(nextImageView)
        nextImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.width.equalTo(16)
        }
        
        
        statusHoldView.addSubview(statusLable)
        statusLable.snp.makeConstraints { make in
            make.right.equalTo(nextImageView.snp.left).offset(0)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(60)
        }
        
        
        
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.equalTo(40)
            make.right.equalTo(statusLable.snp.left).offset(-12)
        }
        
        
        addSubview(subtitleLable)
        subtitleLable.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(2)
            make.left.equalTo(titleLable.snp.left)
            make.right.equalTo(titleLable.snp.right)
        }
        
        addSubview(line)
        line.snp.makeConstraints { make in
            make.top.equalTo(subtitleLable.snp.bottom).offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.bottom.equalToSuperview()
        }
    }
}

extension YHFileListItemView {
    func updateUI() {
        guard let dataModel = dataModel else { return }
        titleLable.text = dataModel.name
        subtitleLable.text = dataModel.typeName
        
        var text : String = "--"
        var color : UIColor = .failColor
        
        
        if dataModel.checkStatus == 2 {
            text = "需重传"
            color = .failColor
            nextImageView.image = UIImage(named: "file_list_right_arrow_red")
        } else if  dataModel.checkStatus == 3 {
            text = "待提交"
            color = .brandMainColor
            nextImageView.image = UIImage(named: "file_list_right_arrow_blue")
        } else {
            text = "需过滤" + String(dataModel.checkStatus)
            color = UIColor.purple
        }
        
        statusLable.text = text
        statusLable.textColor = color
        
        
    }
    
    
    func updateIndex() {
        let index = String(myIndex + 1)
        indexLable.text = index.defaultStringIfEmpty(detaultValue: "-")
    }
    
    @objc func didItemViewClicked() {
        printLog("点击文件清单@")
        clickBlock?(self.dataModel)
    }
}
