//
//  YHHKPlanCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/31.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKPlanCell: UITableViewCell {
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var holdView : UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        view.layer.cornerRadius = kCornerRadius12
        return view
    }()
    
    
    var arrData : [YHHKPlanDocModel] = [] {
        didSet {
            updateUI()
        }
    }
}


private extension YHHKPlanCell {
    func initView() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
    }
    
    
    func updateUI() {
        holdView.removeSubviews()
        var tagView : UIView?
        for item in arrData {
            let view = YHHKPlanItemView()
            view.dataMode = item
            holdView.addSubview(view)
            
            if item.isFirstData {
                view.snp.makeConstraints { make in
                    make.top.equalToSuperview()
                    make.left.equalTo(kMargin)
                    make.right.equalTo(-kMargin)
                }
            } else if item.isLastData {
                view.snp.makeConstraints { make in
                    make.top.equalTo(tagView!.snp.bottom)
                    make.left.equalTo(kMargin)
                    make.right.equalTo(-kMargin)
                    make.bottom.equalToSuperview()
                }
            } else {
                view.snp.makeConstraints { make in
                    make.top.equalTo(tagView!.snp.bottom)
                    make.left.equalTo(kMargin)
                    make.right.equalTo(-kMargin)
                }
            }
            tagView = view
        }
    }
}

