//
//  YHMyDocListHeaderView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
enum ClickButtonType {
    case downAll //全部下载 按钮
    case cancel  //取消 按钮
    case allChoice //全选 按钮
    case downAllCheck //下载确认按钮
}

class YHMyDocListHeaderView: UIView {
    static let viewH : CGFloat = 46.0
    
    typealias Block = (ClickButtonType) -> ()
    var block: Block?
    
    var curShowType : ClickButtonType? {
        didSet {
            updataUI()
        }
    }
    
    var userInfoData : YHMyDocumentsUserModel? {
        didSet {
            updateName()
        }
    }
    
    
    var canShowDownLoadBtnFlag : Bool = false {
        didSet {
            if canShowDownLoadBtnFlag {
                allDownLoadButton.isHidden = false
                cancelButton.isHidden = true
                
            } else {
                allDownLoadButton.isHidden = true
                cancelButton.isHidden = true
            }
        }
    }
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var titleLable : UILabel = {
        let lable0 = UILabel(text: "您好，尊敬的客户")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 21)
        lable0.lineBreakMode = .byTruncatingMiddle
        return lable0
    }()
    
    //批量下载
    private lazy var allDownLoadButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "my_doc_down_icon"), for: .normal)
        button.setTitle("批量下载", for: .normal)
        button.setTitle("批量下载", for: .selected)
        
        button.setTitleColor(.white, for: .normal)
        button.setTitleColor(UIColor.labelTextColor2, for: .highlighted)
        
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 10)
        button.addTarget(self, action: #selector(clickAllBtn), for: .touchUpInside)
        button.layerCornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.iconInLeft(spacing: 2)
        button.isHidden = true
        return button
    }()
    
    //取消
    private lazy var cancelButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("取消", for: .normal)
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.addTarget(self, action: #selector(clickCancelBtn), for: .touchUpInside)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
        button.isHidden = true
        return button
    }()
}

extension YHMyDocListHeaderView {
    func initView() {
        
        backgroundColor = .clear
        
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.right.equalToSuperview()
            make.right.equalTo(-80)
            make.height.equalTo(26)
        }
        
        addSubview(allDownLoadButton)
        allDownLoadButton.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(19)
            make.right.equalToSuperview()
            make.width.equalTo(70)
            make.height.equalTo(24)
        }
        
        allDownLoadButton.layoutIfNeeded()
        allDownLoadButton.addYinHeGradualLayer()
        
        addSubview(cancelButton)
        cancelButton.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(19)
            make.right.equalToSuperview()
            make.width.equalTo(34)
            make.height.equalTo(24)
        }
        
    }
    
    //点击全部下载按钮
    @objc func clickAllBtn() {
        hiddenButton(type: .downAll)
        block?(.downAll)
        
    }
    
    //点击取消按钮
    @objc func clickCancelBtn() {
        hiddenButton(type: .cancel)
        block?(.cancel)
    }
    
    private func hiddenButton(type : ClickButtonType) {
        if type == .downAll {
            allDownLoadButton.isHidden = true
            cancelButton.isHidden = false
        } else if type == .cancel {
            allDownLoadButton.isHidden = false
            cancelButton.isHidden = true
        }
    }
    
    func updataUI() {
        guard let type = curShowType else { return }
        if type == .downAll {
            hiddenButton(type:.cancel)
        } else if type == .cancel {
            hiddenButton(type:.downAll)
        }
    }
    
    
    private func updateName() {
        guard let model = userInfoData else { return }
        if model.username.isEmpty {
            titleLable.text = "您好，尊敬的客户"
        } else {
            var tmp = "您好," + model.username
            if  model.sex == 1 {
                tmp = tmp + "先生"
            } else if model.sex == 2 {
                tmp = tmp + "女士"
            }
            titleLable.text = tmp
        }
    }
}
